unit XMLConfig;

{
  An XML configuration properties handler.
  Requires MSXML v3 package from Microsoft.
  Reads an XML properties file, returning the property name and values
  in a string list. Property names are the accumulated element names
  (ignoring the top level element) separated by periods.
  Values are the text content of the elements.

  For example:
  <?xml version="1.0"?>
  <properties>
    <sub1>
      <prop1>abcdef</prop1>
      <prop2>123456</prop2>
    </sub1>
  </properties>

  becomes

  sub1.prop1=abcdef
  sub1.prop2=123456

  Copyright  Keith Wood (kbwood@iprimus.com.au)
  Version 1.0 - April 25, 2000.
}

interface

uses
  SysUtils, Classes, Windows, ActiveX, MSXML2_TLB;

{ Open the configuration file and then load the properties }
procedure LoadPropertiesFromXML(Filename: string; Props: TStrings);

implementation

{ Open the configuration file and then load the properties }
procedure LoadPropertiesFromXML(Filename: string; Props: TStrings);
var
  XMLDoc: IXMLDOMDocument;
  Index: Integer;

  { Recursively read XML document until text leaves are reached.
    Property name is the accumulated tags to this point (separated by periods).
    Property value is the actual text.
    Add these into a string list using its Values property. }
  procedure LoadSubProperties(Element: IXMLDOMNode; PropPrefix: string);
  var
    Index: Integer;
  begin
    with Element do
      if (NodeType = NODE_TEXT) or (NodeType = NODE_CDATA_SECTION) then
        Props.Values[Copy(PropPrefix, 2, Length(PropPrefix) - 1)] := NodeValue
      else
        for Index := 0 to ChildNodes.Length - 1 do
          LoadSubProperties(ChildNodes[Index], PropPrefix + '.' + NodeName);
  end;

begin
  XMLDoc := CoDOMDocument.Create;
  Props.Clear;
  try
    XMLDoc.Load(Filename);
    { Read through each second level element and process them }
    with XMLDoc.DocumentElement do
      for Index := 0 to ChildNodes.Length - 1 do
        LoadSubProperties(ChildNodes[Index], '');
  finally
    XMLDoc := nil;
  end;
end;

initialization
  { Initialise COM }
  CoInitialize(nil);
finalization
  { Tidy up }
  CoUninitialize();
end.
