unit IDOMGen1;

{
  Demonstrate the generation of an XML document from a database
  using the common DOM framework of Delphi 6+.
  Requires 'movie-watcher' alias to be set up in BDE.

  Copyright  Keith Wood (kbwood@iprimus.com.au)
  Written 24 November, 2002.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, StdCtrls, ExtCtrls, Math, xmldom, CommonXML, oxmldom
  {$IFDEF VER150} { Delphi 7 } , xercesxmldom {$ENDIF} ;

type
  TfrmDOMXML = class(TForm)
    pnlVendor: TPanel;
      Label1: TLabel;
      cmbVendor: TComboBox;
    memXML: TMemo;
    pnlButtons: TPanel;
      btnGenerate: TButton;
      btnSave: TButton;
    dlgSave: TSaveDialog;
    procedure FormCreate(Sender: TObject);
    procedure cmbVendorChange(Sender: TObject);
    procedure btnGenerateClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
  private
  public
  end;

var
  frmDOMXML: TfrmDOMXML;

implementation

{$R *.DFM}

{ Load the vendor list }
procedure TfrmDOMXML.FormCreate(Sender: TObject);
var
  Index: Integer;
begin
  for Index := 0 to DOMVendors.Count - 1 do
    cmbVendor.Items.Add(DOMVendors[Index].Description);
  cmbVendor.ItemIndex := Max(0, cmbVendor.Items.IndexOf(DefaultDOMVendor));
end;

{ Change DOM vendor }
procedure TfrmDOMXML.cmbVendorChange(Sender: TObject);
begin
  memXML.Lines.Clear;
end;

{ Generate the XML document as text }
procedure TfrmDOMXML.btnGenerateClick(Sender: TObject);
var
  XMLDoc: IDOMDocument;

  { Add a simple element that only contains text }
  procedure AddSimpleElement(Parent: IDOMElement; Field: TField;
    AsCDATA: Boolean = False);
  var
    Internal: IDOMElement;
  begin
    Internal := IDOMElement(Parent.appendChild(
      XMLDoc.createElement(ModifyName(Field.FieldName))));
    if AsCDATA then
      Internal.appendChild(XMLDoc.createCDATASection(Field.DisplayText))
    else
      Internal.appendChild(XMLDoc.createTextNode(Field.DisplayText));
  end;

  { Include attributes only if present }
  procedure AddOptAttribute(Element: IDOMElement; Field: TField);
  begin
    if Field.AsString <> '' then
      Element.setAttribute(ModifyName(Field.FieldName), Field.DisplayText);
  end;

  { Include empty field tag only if flag in DB set }
  procedure AddOptElement(Parent: IDOMElement; Field: TField);
  begin
    if Field.AsBoolean then
      Parent.appendChild(
        Parent.ownerDocument.createElement(ModifyName(Field.FieldName)));
  end;

  { Generate XML prolog, style sheet reference, and main element }
  procedure GenerateHeaders;
  var
    Prolog: IDOMXMLProlog;
  begin
    if Supports(XMLDoc, IDOMXMLProlog, Prolog) then
    begin
      Prolog.Version    := '1.0';
      Prolog.Encoding   := 'UTF-8';
      Prolog.Standalone := 'no';
    end;
    with XMLDoc do
    begin
      if documentElement = nil then
        appendChild(createElement(MovieWatcherTag));
      insertBefore(createComment(XMLComment), documentElement);
      insertBefore(createProcessingInstruction(XMLStyleTag, XMLStyleAttrs),
        documentElement);
    end;
  end;

  { Compile elements for the stars of the movie }
  procedure GenerateStars(Starring: IDOMElement);
  begin
    with datCommonXML.qryStars do
    begin
      First;
      while not EOF do
      begin
        AddSimpleElement(Starring, FieldByName(StarField));
        Next;
      end;
    end;
  end;

  { Generate elements for each movie }
  procedure GenerateMovies;
  var
    Movies, Movie: IDOMElement;
  begin
    Movies := IDOMElement(XMLDoc.documentElement.appendChild(
      XMLDoc.createElement(MoviesTag)));
    with datCommonXML.qryMovie do
    begin
      First;
      while not EOF do
      begin
        Movie := IDOMElement(Movies.appendChild(
          XMLDoc.createElement(MovieTag)));
        Movie.setAttribute(Id, FieldByName(MovieIdField).DisplayText);
        Movie.setAttribute(Rating, FieldByName(RatingField).DisplayText);
        AddOptAttribute(Movie, FieldByName(LogoURLField));
        AddOptAttribute(Movie, FieldByName(URLField));
        AddSimpleElement(Movie, FieldByName(NameField));
        AddSimpleElement(Movie, FieldByName(LengthField));
        AddSimpleElement(Movie, FieldByName(DirectorField));
        GenerateStars(IDOMElement(Movie.appendChild(
          XMLDoc.createElement(StarringTag))));
        AddSimpleElement(Movie, FieldByName(SynopsisField), True);
        Next;
      end;
    end;
  end;

  { Compile elements for the pricing schemes }
  procedure GeneratePricing(Pricing: IDOMElement);
  var
    Price: IDOMElement;
  begin
    with datCommonXML.qryPricing do
    begin
      First;
      while not EOF do
      begin
        Price := IDOMElement(Pricing.appendChild(
          Pricing.ownerDocument.createElement(PriceTag)));
        Price.SetAttribute(Id, FieldByName(PricingIdField).DisplayText);
        AddSimpleElement(Price, FieldByName(NameField));
        AddSimpleElement(Price, FieldByName(PeriodField));
        AddSimpleElement(Price, FieldByName(AdultField));
        AddSimpleElement(Price, FieldByName(ChildField));
        if FieldByName(DiscountField).AsFloat <> 0 then
          AddSimpleElement(Price, FieldByName(DiscountField));
        Next;
      end;
    end;
  end;

  { Generate elements for each cinema }
  procedure GenerateCinemas;
  var
    Cinemas, Cinema, Facilities: IDOMElement;
  begin
    Cinemas := IDOMElement(XMLDoc.documentElement.appendChild(
      XMLDoc.createElement(CinemasTag)));
    with datCommonXML.qryCinema do
    begin
      First;
      while not EOF do
      begin
        Cinema := IDOMElement(Cinemas.appendChild(
          XMLDoc.createElement(CinemaTag)));
        Cinema.setAttribute(Id, FieldByName(CinemaIdField).DisplayText);
        AddSimpleElement(Cinema, FieldByName(NameField));
        AddSimpleElement(Cinema, FieldByName(PhoneField));
        AddSimpleElement(Cinema, FieldByName(AddressField));
        AddSimpleElement(Cinema, FieldByName(DirectionsField));
        Facilities := IDOMElement(Cinema.appendChild(
          XMLDoc.createElement(FacilitiesTag)));
        AddOptElement(Facilities, FieldByName(CandyBarField));
        AddOptElement(Facilities, FieldByName(DisabledField));
        GeneratePricing(IDOMElement(Cinema.appendChild(
          XMLDoc.createElement(PricingTag))));
        Next;
      end;
    end;
  end;

  { Compile elements for the sessions for each screening }
  procedure GenerateSessions(Sessions: IDOMElement);
  var
    Session: IDOMElement;
  begin
    with datCommonXML.qrySessions do
    begin
      First;
      while not EOF do
      begin
        Session := IDOMElement(Sessions.appendChild(
          Sessions.ownerDocument.createElement(SessionTag)));
        Session.setAttribute(PricingId,
          FieldByName(PricingIdField).DisplayText);
        AddSimpleElement(Session, FieldByName(TimeField));
        Next;
      end;
    end;
  end;

  { Generate elements for each screening }
  procedure GenerateScreenings;
  var
    Screenings, Screening, Internal: IDOMElement;
  begin
    Screenings := IDOMElement(XMLDoc.documentElement.appendChild(
      XMLDoc.createElement(ScreeningsTag)));
    with datCommonXML.qryScreening do
    begin
      First;
      while not EOF do
      begin
        Screening := IDOMElement(Screenings.appendChild(
          XMLDoc.createElement(ScreeningTag)));
        Screening.setAttribute(MovieId, FieldByName(MovieIdField).DisplayText);
        Screening.setAttribute(CinemaId,
          FieldByName(CinemaIdField).DisplayText);
        AddSimpleElement(Screening, FieldByName(StartDateField));
        AddSimpleElement(Screening, FieldByName(EndDateField));
        Internal := IDOMElement(Screenings.appendChild(
          XMLDoc.createElement(FeaturesTag)));
        AddSimpleElement(Internal, FieldByName(DigSoundField));
        Internal := IDOMElement(Screenings.appendChild(
          XMLDoc.createElement(RestrictionsTag)));
        AddOptElement(Internal, FieldByName(NoPassesField));
        GenerateSessions(IDOMElement(Screenings.appendChild(
          XMLDoc.createElement(SessionsTag))));
        Next;
      end;
    end;
  end;

begin
  Screen.Cursor       := crHourglass;
  btnGenerate.Enabled := False;
  try
    { Instantiate the DOM }
    XMLDoc        := GetDOM(cmbVendor.Items[cmbVendor.ItemIndex]).
      createDocument('', MovieWatcherTag, nil);
    { Generate the structure }
    GenerateHeaders;
    GenerateMovies;
    GenerateCinemas;
    GenerateScreenings;
    { And convert to XML }
    memXML.Lines.Text := (XMLDoc as IDOMPersist).xml;
    { Release the DOM }
    XMLDoc            := nil;
  finally
    btnGenerate.Enabled := True;
    Screen.Cursor       := crDefault;
  end;
end;

{ Save the generated XML }
procedure TfrmDOMXML.btnSaveClick(Sender: TObject);
begin
  with dlgSave do
    if Execute then
      memXML.Lines.SaveToFile(Filename);
end;

end.
