unit MSDOMGen1;

{
  Demonstrate the generation of an XML document from a database
  using the Microsoft Document Object Model (DOM).
  Requires 'movie-watcher' alias to be set up in BDE.
  Requires MSXML v3 package from Microsoft.

  Copyright  Keith Wood (kbwood@iprimus.com.au)
  Written February 16, 1999.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, StdCtrls, ExtCtrls, ActiveX, MSXML2_tlb, CommonXML;

type
  TfrmDOMXML = class(TForm)
    memXML: TMemo;
    pnlButtons: TPanel;
      btnGenerate: TButton;
      btnSave: TButton;
    dlgSave: TSaveDialog;
    procedure btnGenerateClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
  private
  public
  end;

var
  frmDOMXML: TfrmDOMXML;

implementation

{$R *.DFM}

{ Generate the XML document as text }
procedure TfrmDOMXML.btnGenerateClick(Sender: TObject);
var
  XMLDoc: IXMLDOMDocument;

  { Add a simple element that only contains text }
  procedure AddSimpleElement(Parent: IXMLDOMElement; Field: TField;
    AsCDATA: Boolean = False);
  var
    Internal: IXMLDOMElement;
  begin
    Internal := IXMLDOMElement(Parent.appendChild(
      XMLDoc.createElement(ModifyName(Field.FieldName))));
    if AsCDATA then
      Internal.appendChild(XMLDoc.createCDATASection(Field.DisplayText))
    else
      Internal.appendChild(XMLDoc.createTextNode(Field.DisplayText));
  end;

  { Include attributes only if present }
  procedure AddOptAttribute(Element: IXMLDOMElement; Field: TField);
  begin
    if Field.AsString <> '' then
      Element.setAttribute(ModifyName(Field.FieldName), Field.DisplayText);
  end;

  { Include empty field tag only if flag in DB set }
  procedure AddOptElement(Parent: IXMLDOMElement; Field: TField);
  begin
    if Field.AsBoolean then
      Parent.appendChild(
        Parent.ownerDocument.createElement(ModifyName(Field.FieldName)));
  end;

  { Generate XML prolog, style sheet reference, and main element }
  procedure GenerateHeaders;
  begin
    with XMLDoc do
    begin
      appendChild(createProcessingInstruction(XMLTag, XMLPrologAttrs));
      appendChild(createComment(XMLComment));
      appendChild(createProcessingInstruction(XMLStyleTag, XMLStyleAttrs));
      appendChild(createElement(MovieWatcherTag));
    end;
  end;

  { Compile elements for the stars of the movie }
  procedure GenerateStars(Starring: IXMLDOMElement);
  begin
    with datCommonXML.qryStars do
    begin
      First;
      while not EOF do
      begin
        AddSimpleElement(Starring, FieldByName(StarField));
        Next;
      end;
    end;
  end;

  { Generate elements for each movie }
  procedure GenerateMovies;
  var
    Movies, Movie: IXMLDOMElement;
  begin
    Movies := IXMLDOMElement(XMLDoc.documentElement.appendChild(
      XMLDoc.createElement(MoviesTag)));
    with datCommonXML.qryMovie do
    begin
      First;
      while not EOF do
      begin
        Movie := IXMLDOMElement(Movies.appendChild(
          XMLDoc.createElement(MovieTag)));
        Movie.setAttribute(Id, FieldByName(MovieIdField).DisplayText);
        Movie.setAttribute(Rating, FieldByName(RatingField).DisplayText);
        AddOptAttribute(Movie, FieldByName(LogoURLField));
        AddOptAttribute(Movie, FieldByName(URLField));
        AddSimpleElement(Movie, FieldByName(NameField));
        AddSimpleElement(Movie, FieldByName(LengthField));
        AddSimpleElement(Movie, FieldByName(DirectorField));
        GenerateStars(IXMLDOMElement(Movie.appendChild(
          XMLDoc.createElement(StarringTag))));
        AddSimpleElement(Movie, FieldByName(SynopsisField), True);
        Next;
      end;
    end;
  end;

  { Compile elements for the pricing schemes }
  procedure GeneratePricing(Pricing: IXMLDOMElement);
  var
    Price: IXMLDOMElement;
  begin
    with datCommonXML.qryPricing do
    begin
      First;
      while not EOF do
      begin
        Price := IXMLDOMElement(Pricing.appendChild(
          Pricing.ownerDocument.createElement(PriceTag)));
        Price.setAttribute(Id, FieldByName(PricingIdField).DisplayText);
        AddSimpleElement(Price, FieldByName(NameField));
        AddSimpleElement(Price, FieldByName(PeriodField));
        AddSimpleElement(Price, FieldByName(AdultField));
        AddSimpleElement(Price, FieldByName(ChildField));
        if FieldByName(DiscountField).AsFloat <> 0 then
          AddSimpleElement(Price, FieldByName(DiscountField));
        Next;
      end;
    end;
  end;

  { Generate elements for each cinema }
  procedure GenerateCinemas;
  var
    Cinemas, Cinema, Facilities: IXMLDOMElement;
  begin
    Cinemas := IXMLDOMElement(XMLDoc.documentElement.appendChild(
      XMLDoc.createElement(CinemasTag)));
    with datCommonXML.qryCinema do
    begin
      First;
      while not EOF do
      begin
        Cinema := IXMLDOMElement(Cinemas.appendChild(
          XMLDoc.createElement(CinemaTag)));
        Cinema.setAttribute(Id, FieldByName(CinemaIdField).DisplayText);
        AddSimpleElement(Cinema, FieldByName(NameField));
        AddSimpleElement(Cinema, FieldByName(PhoneField));
        AddSimpleElement(Cinema, FieldByName(AddressField));
        AddSimpleElement(Cinema, FieldByName(DirectionsField));
        Facilities := IXMLDOMElement(Cinema.appendChild(
          XMLDoc.createElement(FacilitiesTag)));
        AddOptElement(Facilities, FieldByName(CandyBarField));
        AddOptElement(Facilities, FieldByName(DisabledField));
        GeneratePricing(IXMLDOMElement(Cinema.appendChild(
          XMLDoc.createElement(PricingTag))));
        Next;
      end;
    end;
  end;

  { Compile elements for the sessions for each screening }
  procedure GenerateSessions(Sessions: IXMLDOMElement);
  var
    Session: IXMLDOMElement;
  begin
    with datCommonXML.qrySessions do
    begin
      First;
      while not EOF do
      begin
        Session := IXMLDOMElement(Sessions.appendChild(
          Sessions.ownerDocument.createElement(SessionTag)));
        Session.setAttribute(PricingId,
          FieldByName(PricingIdField).DisplayText);
        AddSimpleElement(Session, FieldByName(TimeField));
        Next;
      end;
    end;
  end;

  { Generate elements for each screening }
  procedure GenerateScreenings;
  var
    Screenings, Screening, Internal: IXMLDOMElement;
  begin
    Screenings := IXMLDOMElement(XMLDoc.documentElement.appendChild(
      XMLDoc.createElement(ScreeningsTag)));
    with datCommonXML.qryScreening do
    begin
      First;
      while not EOF do
      begin
        Screening := IXMLDOMElement(Screenings.appendChild(
          XMLDoc.createElement(ScreeningTag)));
        Screening.setAttribute(MovieId, FieldByName(MovieIdField).DisplayText);
        Screening.setAttribute(CinemaId,
          FieldByName(CinemaIdField).DisplayText);
        AddSimpleElement(Screening, FieldByName(StartDateField));
        AddSimpleElement(Screening, FieldByName(EndDateField));
        Internal := IXMLDOMElement(Screenings.appendChild(
          XMLDoc.createElement(FeaturesTag)));
        AddSimpleElement(Internal, FieldByName(DigSoundField));
        Internal := IXMLDOMElement(Screenings.appendChild(
          XMLDoc.createElement(RestrictionsTag)));
        AddOptElement(Internal, FieldByName(NoPassesField));
        GenerateSessions(IXMLDOMElement(Screenings.appendChild(
          XMLDoc.createElement(SessionsTag))));
        Next;
      end;
    end;
  end;

begin
  Screen.Cursor       := crHourglass;
  btnGenerate.Enabled := False;
  try
    { Instantiate the DOM }
    XMLDoc        := CoDOMDocument.Create;
    { Generate the structure }
    GenerateHeaders;
    GenerateMovies;
    GenerateCinemas;
    GenerateScreenings;
    { And convert to XML }
    memXML.Lines.Text := XMLDoc.xml;
    { Release the DOM }
    XMLDoc            := nil;
  finally
    btnGenerate.Enabled := True;
    Screen.Cursor       := crDefault;
  end;
end;

{ Save the generated XML }
procedure TfrmDOMXML.btnSaveClick(Sender: TObject);
begin
  with dlgSave do
    if Execute then
      memXML.Lines.SaveToFile(Filename);
end;

initialization
  CoInitialize(nil);
finalization
  CoUninitialize;
end.
