unit ClientDetail;

{
  Popup form to show movie details.
  
  Copyright  Keith Wood (kbwood@iprimus.com.au)
  Written 17 September, 2002.
}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, FindMoviesIntf;

type
  TfrmClientDetail = class(TForm)
    Label1: TLabel;
    edtName: TEdit;
    Label2: TLabel;
    edtRating: TEdit;
    Label3: TLabel;
    edtLength: TEdit;
    Label4: TLabel;
    edtDirector: TEdit;
    Label5: TLabel;
    lbxStars: TListBox;
    Label6: TLabel;
    memSynopsis: TMemo;
    btnOK: TButton;
  private
  public
    class procedure Display(Movie: TMovieDetails);
  end;

implementation

{$R *.dfm}

{ TfrmClientDetail }

class procedure TfrmClientDetail.Display(Movie: TMovieDetails);
var
  Index: Integer;
begin
  with TfrmClientDetail.Create(nil) do
    try
      edtName.Text           := Movie.Name;
      edtRating.Text         := Ratings[Movie.Rating];
      edtLength.Text         := IntToStr(Movie.Length);
      edtDirector.Text       := Movie.Director;
      memSynopsis.Lines.Text := Movie.Synopsis;
      for Index := 0 to Length(Movie.Stars) - 1 do
        lbxStars.Items.Add(Movie.Stars[Index]);
      ShowModal;
    finally
      Free;
    end;
end;

end.
