<?xml version="1.0" encoding="UTF-8"?>
<!-- Examination Question Stylesheet
     Show a single question with possible answers
     Written by Keith Wood, 16 June, 2000 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <!-- The answer(s) selected by the examinee -->
  <xsl:param name="answer">tobject</xsl:param>
  <!-- The name of the script processing this page -->
  <xsl:param name="engine">webexam.dll</xsl:param>
  <!-- The id of the question to display -->
  <xsl:param name="qid">Q3</xsl:param>
  <!-- The question's ordinal position in the exam -->
  <xsl:param name="qno">2</xsl:param>
  <!-- Set to 'true' to show results, 'false' for initial questioning -->
  <xsl:param name="results">true</xsl:param>
  <!-- The user's id -->
  <xsl:param name="ses">123</xsl:param>

  <!-- The overall document -->
  <xsl:template match="/">
    <html>
    <head>
    <title><xsl:value-of select="exam/title"/> - Question <xsl:value-of select="$qno"/></title>
    </head>
    <body>
    <xsl:apply-templates select="id($qid)"/>
    <hr/>
    <p>Written by <a href="mailto:kbwood@iprimus.com.au">Keith Wood</a>.</p>
    </body>
    </html>
  </xsl:template>

  <!-- Display text for a single question -->
  <xsl:template match="question">
    <form method="post" action="{$engine}">
      <table border="0" width="100%">
        <tr><td colspan="2"><h2>Question <xsl:value-of select="$qno"/></h2></td>
        </tr>
        <tr><th align="right" valign="top">Query:</th>
          <td><pre><xsl:value-of select="query"/></pre></td>
        </tr>
        <tr><th align="right" valign="top">Answer:</th>
          <td>
            <table border="0">
              <xsl:apply-templates select="answers"/>
            </table>
          </td>
        </tr>
        <xsl:if test="$results='true'">
        <tr><th align="right" valign="top">Explanation:</th>
          <td><p><xsl:value-of select="explanation"/></p></td>
        </tr>
        </xsl:if>
      </table>
      <div align="center" xml:space="preserve">
        <input type="hidden" name="ses" value="{$ses}"/>
        <input type="hidden" name="qno" value="{$qno}"/>
        <input type="submit" name="act" value="Previous"/>
        <input type="submit" name="act" value="Next"/>
        <xsl:if test="$results='true'">
          <input type="submit" name="act" value="Results"/>
        </xsl:if>
      </div>
    </form>
  </xsl:template>

  <!-- Format answers for radio button/checkbox type responses -->
  <xsl:template match="answers[@type!='text']/answer">
    <tr>
      <td>
        <xsl:choose>
          <xsl:when test="$results='true' and @correct='true'">
            <xsl:choose>
              <xsl:when test="contains($answer,string(position() - 1))">
                <img src="images/correct.gif" alt="Correct" height="16" width="16"/>
              </xsl:when>
              <xsl:otherwise>
                <img src="images/incorrect.gif" alt="Incorrect" height="16" width="16"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <img src="images/blank.gif" height="16" width="16"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td><input name="answer" type="{../@type}" value="{position() - 1}">
        <xsl:if test="contains($answer,string(position() - 1))"><xsl:attribute name="checked"/></xsl:if>
        </input><xsl:value-of select="."/></td>
    </tr>
  </xsl:template>

  <!-- Format answers for text type responses -->
  <xsl:template match="answers[@type='text']">
    <tr>
      <td>
        <xsl:choose>
          <xsl:when test="$results='true'">
            <xsl:choose>
              <xsl:when test="answer=$answer">
                <img src="images/correct.gif" alt="Correct" height="16" width="16"/>
              </xsl:when>
              <xsl:otherwise>
                <img src="images/incorrect.gif" alt="Incorrect" height="16" width="16"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <img src="images/blank.gif" height="16" width="16"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td><input name="answer" type="text" value="{$answer}"/></td>
    </tr>
    <xsl:if test="$results='true'">
    <tr>
      <td colspan="2">Valid answers: <xsl:apply-templates select="answer"/></td>
    </tr>
    </xsl:if>
  </xsl:template>

  <!-- Format correct answers for text type responses -->
  <xsl:template match="answers[@type='text']/answer">
    <xsl:value-of select="."/><xsl:if test="position()!=last()">,</xsl:if>
  </xsl:template>
</xsl:stylesheet>
