<?xml version="1.0" encoding="UTF-8"?>
<!-- Examination Results Stylesheet
     Show the outcome of the examination, with links back to the questions
     Written by Keith Wood, 16 June, 2000 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:exam="urn:keith/exams">
  <!-- Are the questions answered correctly -->
  <xsl:param name="answers">Y N</xsl:param>
  <!-- The name of the script processing this page -->
  <xsl:param name="engine">webexam.dll</xsl:param>
  <!-- The user's id -->
  <xsl:param name="ses">123</xsl:param>

  <!-- Functions to count answers -->
  <msxsl:script language="JScript" implements-prefix="exam">
    <![CDATA[
    // How many answered?
    function getCount(answers) {
      var count = 0;
      for (index = 0; index < answers.length; index++)
        if (answers.charAt(index) != ' ')
          count++;
      return count;
    }

    // How many correct?
    function getScore(answers) {
      var score = 0;
      for (index = 0; index < answers.length; index++)
        if (answers.charAt(index) == 'Y')
          score++;
      return score;
    }
    ]]>
  </msxsl:script>

  <!-- The overall document -->
  <xsl:template match="/">
    <html>
    <head>
    <title><xsl:value-of select="exam/title"/> Results</title>
    <style>
      .passed { color=green; font-weight=bold; }
      .failed { color=red; font-weight=bold; }
    </style>
    </head>
    <body>
    <xsl:apply-templates select="exam"/>
    <hr/>
    <p>Written by <a href="mailto:kbwood@iprimus.com.au">Keith Wood</a>.</p>
    </body>
    </html>
  </xsl:template>

  <!-- Display outcome of examination -->
  <xsl:template match="exam">
    <h1><xsl:value-of select="title"/> Results</h1>
    <p><xsl:value-of select="description"/></p>
    <table border="0" width="100%">
      <tr>
        <td width="50%" valign="top">
          <p>This test has a pass mark of
          <strong><xsl:value-of select="@pass_mark"/>%</strong>.</p>
          <p>You have answered <strong><xsl:value-of select="exam:getCount(string($answers))"/></strong>
            out of <strong><xsl:value-of select="count(question)"/></strong> questions.</p>
          <p>Your score is <strong><xsl:value-of select="exam:getScore(string($answers))"/></strong>.</p>
          <xsl:choose>
            <xsl:when test="(exam:getScore(string($answers))*100 div count(question))>=number(@pass_mark)">
              <p>You have <span class="passed">passed</span>.</p>
            </xsl:when>
            <xsl:otherwise>
              <p>You have <span class="failed">failed</span>.</p>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td width="50%" valign="top">
          <xsl:apply-templates select="question"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <!-- Provide a link back to the question -->
  <xsl:template match="question">
    <xsl:choose>
      <xsl:when test="substring($answers, position(), 1)='Y'">
        <img src="images/correct.gif" alt="Correct" height="16" width="16"/>
      </xsl:when>
      <xsl:when test="substring($answers, position(), 1)='N'">
        <img src="images/incorrect.gif" alt="Incorrect" height="16" width="16"/>
      </xsl:when>
      <xsl:otherwise>
        <img src="images/blank.gif" height="16" width="16"/>
      </xsl:otherwise>
    </xsl:choose>
    <a href="{$engine}?ses={$ses}&amp;act=Goto&amp;qno={position()}">
      Question <xsl:value-of select="position()"/>
    </a><br/>
  </xsl:template>
</xsl:stylesheet>
