package wood.keith.opentools.actions;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

import com.borland.jbuilder.JBuilderMenu;
import com.borland.primetime.PrimeTime;
import com.borland.primetime.actions.ActionGroup;
import com.borland.primetime.editor.EditorAction;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.BrowserAction;
import com.borland.primetime.ide.BrowserStateAction;

/**
 * Sampler of various action types in JBuilder.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  10 March 2002
 */
public class ActionSampler extends ActionGroup {

  /**
   * Add the action group to the menu.
   *
   * @param  majorVersion  the major version of the current OpenTools API
   * @param  minorVersion  the minor version of the current OpenTools API
   */
  public static void initOpenTool(byte majorVersion, byte minorVersion) {
    if (majorVersion != PrimeTime.CURRENT_MAJOR_VERSION) {
      return;
    }
    JBuilderMenu.GROUP_Tools.add(new ActionSampler());
  }

  /**
   * Add actions to the group.
   */
  public ActionSampler() {
    super("Action Sampler", 'C');
    setSmallIcon(new ImageIcon(ClassLoader.getSystemResource(
        "com/borland/jbuilder/designer/tree/image/PopupMenu.gif")));
    setPopup(true);
    this.add(browserSample);
    this.add(browserStateSample);
    this.add(editorSample);
  }

  /**
   * Example of a BrowserAction - shows the title of the browser.
   */
  public static BrowserAction browserSample =
      new BrowserAction("Browser title", 'B') {
    public void actionPerformed(Browser browser) {
      JOptionPane.showMessageDialog(browser,
          "BrowserAction for " + browser.getTitle());
    }

    public void update(Browser browser) {
      setLongText(browser.getTitle());
    }
  };

  /**
   * Example of a BrowserStateAction - toggles L&F.
   */
  public static BrowserStateAction browserStateSample =
      new BrowserStateAction("Metal L&F", 'M') {

    private final String metal = UIManager.getCrossPlatformLookAndFeelClassName();
    private final String platform = UIManager.getSystemLookAndFeelClassName();

    public boolean getState(Browser browser) {
      return browser.getIDELookAndFeelClassName().equals(metal);
    }

    public void setState(Browser browser, boolean state) {
      browser.setIDELookAndFeelClassName(state ? metal : platform);
    }

    public void update(Browser browser) {
      setLongText(browser.getIDELookAndFeelClassName().equals(metal) ?
          "Swap to native L&F" : "Swap to Metal L&F");
    }
  };

  /**
   * Example of an EditorAction - toggles editor background colour.
   */
  public static EditorAction editorSample =
      new EditorAction("Toggle editor background") {

    public void actionPerformed(ActionEvent event) {
      EditorPane editor = getEditorTarget(event);
      if (editor != null) {
        Color colour = editor.getBackground();
        editor.setBackground(colour.equals(Color.white) ?
            Color.yellow : Color.white);
      }
    }

    public String toString() {
      return (String)getValue(Action.NAME);
    }
  };
}
