/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.browser;

import com.borland.primetime.PrimeTime;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.BrowserAdapter;
import com.borland.primetime.ide.BrowserListener;
import com.borland.primetime.node.Node;

public class BrowserNumberer
extends BrowserAdapter {
    private static final String VERSION = "1.0";

    public static void initOpenTool(byte majorVersion, byte minorVersion) {
        if (majorVersion != 4) {
            return;
        }
        Browser.addStaticBrowserListener((BrowserListener)new BrowserNumberer());
        if (PrimeTime.isVerbose()) {
            System.out.println("Loaded BrowserNumberer v1.0");
            System.out.println("Written by Keith Wood (kbwood@iprimus.com.au)");
        }
    }

    public void browserNodeActivated(Browser browser, Node node) {
        this.renumberBrowsers();
    }

    public void browserClosed(Browser browser) {
        this.renumberBrowsers();
    }

    public void browserOpened(Browser browser) {
        this.renumberBrowsers();
    }

    private void renumberBrowsers() {
        Browser[] browsers = Browser.getBrowsersNonZ();
        int index = 0;
        while (index < browsers.length) {
            Node node = browsers[index].getActiveNode();
            browsers[index].setTitle(Browser.getBrowserTitle() + ":" + (index + 1) + (node == null ? "" : " - " + node.getLongDisplayName()));
            ++index;
        }
    }
}

