/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.browser;

import com.borland.primetime.Command;
import com.borland.primetime.PrimeTime;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.BrowserAdapter;
import com.borland.primetime.ide.BrowserListener;
import com.borland.primetime.ide.NodeViewer;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.Project;
import com.borland.primetime.util.VetoException;
import java.awt.Component;
import java.io.PrintStream;
import javax.swing.JOptionPane;

public class BrowserTrace
extends BrowserAdapter
implements Command {
    private static final String VERSION = "1.0";
    private static final String LEADER = "BrowserTrace: ";
    private static final String DESCR = "Display browser events to standard output";
    private static final String USAGE = "  Registers a global BrowserListener and writes all browser events to standard output.";
    private static final BrowserTrace TRACER = new BrowserTrace();

    public static void initOpenTool(byte majorVersion, byte minorVersion) {
        if (majorVersion != 4) {
            return;
        }
        PrimeTime.registerCommand((String)"browsertrace", (Command)TRACER);
        if (PrimeTime.isVerbose()) {
            System.out.println("Loaded browsertrace command v1.0");
            System.out.println("Written by Keith Wood (kbwood@iprimus.com.au)");
        }
    }

    public void printCommandHelp(PrintStream out) {
        out.println(USAGE);
    }

    public String getCommandDescription() {
        return DESCR;
    }

    public void invokeCommand(String[] args) {
        Browser.addStaticBrowserListener((BrowserListener)TRACER);
    }

    public boolean takesCommandArguments() {
        return false;
    }

    public void browserViewerDeactivating(Browser browser, Node node, NodeViewer viewer) throws VetoException {
        System.out.println("BrowserTrace: viewerDeactivating " + browser.getBrowserTitle() + " " + node.getDisplayName() + " " + (viewer == null ? "null" : viewer.getViewerTitle()));
        this.check(browser, "Allow browserViewerDeactivating");
    }

    public void browserViewerActivated(Browser browser, Node node, NodeViewer viewer) {
        System.out.println("BrowserTrace: viewerActivated " + browser.getBrowserTitle() + " " + node.getDisplayName() + " " + (viewer == null ? "null" : viewer.getViewerTitle()));
    }

    public void browserNodeClosed(Browser browser, Node node) {
        System.out.println("BrowserTrace: nodeClosed " + browser.getBrowserTitle() + " " + (node == null ? "null" : node.getDisplayName()));
    }

    public void browserNodeActivated(Browser browser, Node node) {
        System.out.println("BrowserTrace: nodeActivated " + browser.getBrowserTitle() + " " + (node == null ? "null" : node.getDisplayName()));
    }

    public void browserProjectClosed(Browser browser, Project project) {
        System.out.println("BrowserTrace: projectClosed " + browser.getBrowserTitle() + " " + (project == null ? "null" : project.getDisplayName()));
    }

    public void browserProjectActivated(Browser browser, Project project) {
        System.out.println("BrowserTrace: projectActivated " + browser.getBrowserTitle() + " " + (project == null ? "null" : project.getDisplayName()));
    }

    public void browserClosed(Browser browser) {
        System.out.println("BrowserTrace: closed " + browser.getBrowserTitle());
    }

    public void browserClosing(Browser browser) throws VetoException {
        System.out.println("BrowserTrace: closing " + browser.getBrowserTitle());
        this.check(browser, "Allow browserClosing");
    }

    public void browserDeactivated(Browser browser) {
        System.out.println("BrowserTrace: deactivated " + browser.getBrowserTitle());
    }

    public void browserActivated(Browser browser) {
        System.out.println("BrowserTrace: activated " + browser.getBrowserTitle());
    }

    public void browserOpened(Browser browser) {
        System.out.println("BrowserTrace: opened " + browser.getBrowserTitle());
    }

    private void check(Browser browser, String message) throws VetoException {
        if (JOptionPane.showConfirmDialog((Component)browser, message, LEADER, 0) == 1) {
            throw new VetoException(message);
        }
    }
}

