package wood.keith.opentools.browser;

import javax.swing.JLabel;

import com.borland.jbuilder.JBuilderMenu;
import com.borland.primetime.PrimeTime;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.BrowserAction;
import com.borland.primetime.ide.NodeViewer;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.util.VetoException;

/**
 * Provide information from the Browser - sent to standard output.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  22 March 2002
 */
public class BrowserInfo {

  /**
   * Register action with the menu.
   *
   * @param  majorVersion  the major version of the current OpenTools API
   * @param  minorVersion  the minor version of the current OpenTools API
   */
  public static void initOpenTool(byte majorVersion, byte minorVersion) {
    if (majorVersion != PrimeTime.CURRENT_MAJOR_VERSION) {
      return;
    }
    JBuilderMenu.GROUP_Tools.add(BROWSER_INFO);
    if (PrimeTime.isVerbose()) {
      System.out.println("Loaded BrowserInfo");
      System.out.println("Written by Keith Wood (kbwood@iprimus.com.au)");
    }
  }

  /**
   * Display information about the browser objects.
   */
  public static final BrowserAction BROWSER_INFO = new BrowserAction(
      "Browser info", 'I', "Display browser information on output") {

    public void actionPerformed(Browser browser) {
      // Basic browser info
      System.out.println("Browser information:");
      // Global title
      System.out.println("getBrowserTitle " + browser.getBrowserTitle());
      // Number of open browsers
      System.out.println("getBrowserCount " + browser.getBrowserCount());
      // Open browsers in opening order
      Browser[] browsers = browser.getBrowsers();
      for (int index = 0; index < browsers.length; index++) {
        System.out.println("getBrowsers " + index + " " +
          browsers[index].getTitle());
      }
      // Open browsers in reverse opening order
      browsers = browser.getBrowsersNonZ();
      for (int index = 0; index < browsers.length; index++) {
        System.out.println("getBrowsersNonZ " + index + " " +
          browsers[index].getTitle());
      }
      Node[] nodes;
      // Navigation  history - these are only available in JB4
//      System.out.println("canNavigateBack " + browser.canNavigateBack());
//      System.out.println("canNavigateForward " + browser.canNavigateForward());
//      System.out.println("getNavigationHistoryCount " +
//        browser.getNavigationHistoryCount());
//      System.out.println("getNavigationIndex " +
//        browser.getNavigationIndex());
//      nodes = browser.getNavigationHistory();
//      for (int index = 0; index < nodes.length; index++) {
//        System.out.println("getNavigationHistory " + index + " " +
//          nodes[index].getDisplayName());
//      }
      // Active objects
      System.out.println("getActiveNode " + browser.getActiveNode());
      System.out.println("getActiveProject " + browser.getActiveProject());
      System.out.println("getActiveUserProject " +
        browser.getActiveUserProject());
      // Open nodes for all browsers
      nodes = browser.getAllOpenNodes();
      for (int index = 0; index < nodes.length; index++) {
        System.out.println("getAllOpenNodes " + index + " " +
          nodes[index].getDisplayName());
      }
      nodes = browser.getAllOpenNodes(browser.getActiveProject());
      for (int index = 0; index < nodes.length; index++) {
        System.out.println("getAllOpenNodes(proj) " + index + " " +
          nodes[index].getDisplayName());
      }
      // Open nodes for this browser
      System.out.println("getOpenNodeCount " + browser.getOpenNodeCount());
      nodes = browser.getOpenNodes();
      for (int index = 0; index < nodes.length; index++) {
        System.out.println("getOpenNodes " + index + " " +
          nodes[index].getDisplayName());
      }
      nodes = browser.getOpenNodes(browser.getActiveProject());
      for (int index = 0; index < nodes.length; index++) {
        System.out.println("getOpenNodes(proj) " + index + " " +
          nodes[index].getDisplayName());
      }
      // Miscellaneous
      System.out.println("getIDELookAndFeelClassName " +
        browser.getIDELookAndFeelClassName());
      System.out.println("getLastDirectory " + browser.getLastDirectory());
      System.out.println("getLastOpenedUrl " + browser.getLastOpenedUrl());
      // Node info for the active node
      Node node = browser.getActiveNode();
      System.out.println("isOpenNode " + browser.isOpenNode(node));
      System.out.println("canDisplayNode " + browser.canDisplayNode(node));
      System.out.println("getViewerCount " + browser.getViewerCount(node));
      System.out.println("getActiveViewer " +
        (browser.getActiveViewer(node) == null ? "null" :
        browser.getActiveViewer(node).getViewerTitle()));
      NodeViewer[] viewers = browser.getViewers(node);
      for (int index = 0; index < viewers.length; index++) {
        System.out.println("getViewers " + index + " " +
          viewers[index].getViewerTitle());
      }
      // Node info for a non-existent node
      node = browser.getActiveProject().createFileNode(".xxx");
      System.out.println("isOpenNode* " + browser.isOpenNode(node));
      System.out.println("canDisplayNode* " + browser.canDisplayNode(node));
      System.out.println("getViewerCount* " + browser.getViewerCount(node));
      System.out.println("getActiveViewer* " +
        (browser.getActiveViewer(node) == null ? "null" :
        browser.getActiveViewer(node).getViewerTitle()));
      viewers = browser.getViewers(node);
      for (int index = 0; index < viewers.length; index++) {
        System.out.println("getViewers* " + index + " " +
          viewers[index].getViewerTitle());
      }
      // Find browser
      System.out.println("findBrowser " +
        browser.findBrowser(browser.getProjectView()).getTitle());
      System.out.println("findBrowser " +
        browser.findBrowser(new JLabel()).getTitle());
      // Ask to save all modified files
      try {
        browser.doSaveAll(true);
      }
      catch (VetoException ve) {
        ve.printStackTrace();
      }
    }
  };
}