package wood.keith.opentools.browser;

import com.borland.primetime.PrimeTime;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.BrowserAdapter;
import com.borland.primetime.node.Node;

/**
 * Add a number suffix to browser windows as opened and closed.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0 22 March 2002
 */
public class BrowserNumberer extends BrowserAdapter {

  private static final String VERSION = "1.0";

  /**
   * Register the listener.
   *
   * @param  majorVersion  the major version of the current OpenTools API
   * @param  minorVersion  the minor version of the current OpenTools API
   */
  public static void initOpenTool(byte majorVersion, byte minorVersion) {
    if (majorVersion != PrimeTime.CURRENT_MAJOR_VERSION) {
      return;
    }
    Browser.addStaticBrowserListener(new BrowserNumberer());
    if (PrimeTime.isVerbose()) {
      System.out.println("Loaded BrowserNumberer v" + VERSION);
      System.out.println("Written by Keith Wood (kbwood@iprimus.com.au)");
    }
  }

  public void browserNodeActivated(Browser browser, Node node) {
    renumberBrowsers();
  }

  public void browserClosed(Browser browser) {
    renumberBrowsers();
  }

  public void browserOpened(Browser browser) {
    renumberBrowsers();
  }

  /**
   * Renumber all open browsers.
   */
  private void renumberBrowsers() {
    Browser[] browsers = Browser.getBrowsersNonZ();
    for (int index = 0; index < browsers.length; index++) {
      Node node = browsers[index].getActiveNode();
      browsers[index].setTitle(Browser.getBrowserTitle() + ":" + (index + 1) +
          (node == null ? "" : " - " + node.getLongDisplayName()));
    }
  }
}
