/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.buildnumber;

import com.borland.primetime.build.BuildProcess;
import com.borland.primetime.build.BuildTask;
import com.borland.primetime.util.Strings;
import com.borland.primetime.vfs.Buffer;
import com.borland.primetime.vfs.ReadOnlyException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import wood.keith.opentools.buildnumber.BuildNumberNode;

public class BuildNumberBuildTask
extends BuildTask {
    public static final String BUILD_TASK_KEY = "BuildNumber";
    protected String compilingStatusMessage = "Updating build number for {0}...";
    protected String invocationErrorMessage = "Invocation Error.";
    String eol = System.getProperty("line.separator");
    private ArrayList sourceFiles = new ArrayList();

    public void addBuildSource(BuildNumberNode node) {
        this.sourceFiles.add(node);
    }

    public boolean build(BuildProcess process) {
        for (int j = 0; j < this.sourceFiles.size() && !process.isCancelled(); ++j) {
            this.buildOneNode(process, (BuildNumberNode)((Object)this.sourceFiles.get(j)));
        }
        return true;
    }

    private void buildOneNode(BuildProcess process, BuildNumberNode filenode) {
        if (filenode != null) {
            process.fireBuildStatus(Strings.format((String)this.compilingStatusMessage, (Object)filenode.getDisplayName()), true);
            BuildNumberNode.blat("Building ".concat(String.valueOf(String.valueOf(filenode.getDisplayName()))));
            try {
                Properties nodeProps = filenode.getProps();
                String toolDisabled = System.getProperty("BuildNumberOT.disabled", "false");
                if (this.isTrue(toolDisabled)) {
                    process.fireBuildProblem(filenode.getUrl(), false, String.valueOf(String.valueOf(filenode.getDisplayName())).concat(": BuildNumberOT is disabled."), 1, 1, null);
                    return;
                }
                String nodeDisabled = nodeProps.getProperty("disabled", "false");
                if (this.isTrue(nodeDisabled)) {
                    process.fireBuildProblem(filenode.getUrl(), false, String.valueOf(String.valueOf(filenode.getDisplayName())).concat(": node is disabled."), 1, 1, null);
                    return;
                }
                Buffer buffer = filenode.getBuffer();
                this.incrementLinesInBuffer(process, filenode);
            }
            catch (IOException ioex) {
                process.fireBuildProblem(filenode.getUrl(), true, ioex.getMessage(), 1, 1, null);
            }
            catch (Exception ex) {
                process.fireBuildProblem(filenode.getUrl(), true, ex.getMessage(), 1, 1, null);
            }
        }
    }

    private boolean isTrue(String value) {
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("1");
    }

    private void incrementLinesInBuffer(BuildProcess process, BuildNumberNode filenode) {
        try {
            filenode.updateProps();
        }
        catch (ReadOnlyException roex) {
            process.fireBuildProblem(filenode.getUrl(), true, roex.getMessage(), 1, 1, null);
        }
        catch (IOException ioex) {
            process.fireBuildProblem(filenode.getUrl(), true, ioex.getMessage(), 1, 1, null);
        }
        catch (Exception ex) {
            process.fireBuildProblem(filenode.getUrl(), true, ex.getMessage(), 1, 1, null);
        }
    }

    static {
        BUILD_TASK_KEY = BUILD_TASK_KEY;
    }
}

