/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.buildnumber;

import com.borland.jbuilder.build.CopiedResource;
import com.borland.primetime.PrimeTime;
import com.borland.primetime.ide.BrowserIcons;
import com.borland.primetime.node.DuplicateNodeException;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.Project;
import com.borland.primetime.node.TextFileNode;
import com.borland.primetime.vfs.ReadOnlyException;
import com.borland.primetime.vfs.Url;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.Icon;

public class BuildNumberNode
extends TextFileNode
implements CopiedResource {
    public static String version = "1.4A";
    public static String buildNo = "0";
    private static URL buildNoURL;
    private static Properties buildProps;
    protected static boolean DEBUG;
    static /* synthetic */ Class class$wood$keith$opentools$buildnumber$BuildNumberNode;

    public static void initOpenTool(byte major, byte minor) {
        DEBUG = Boolean.getBoolean("BuildNumberOT.debug");
        if (major == 4) {
            if (PrimeTime.isVerbose()) {
                BuildNumberNode.loadBuildNo();
                BuildNumberNode.printAbout(major, minor);
            }
            FileNode.registerFileNodeClass((String)"num", (String)"Build Number", (Class)(class$wood$keith$opentools$buildnumber$BuildNumberNode == null ? (class$wood$keith$opentools$buildnumber$BuildNumberNode = BuildNumberNode.class$("wood.keith.opentools.buildnumber.BuildNumberNode")) : class$wood$keith$opentools$buildnumber$BuildNumberNode), (Icon)BrowserIcons.ICON_REBUILD);
        } else {
            System.out.println("BuildNumberOT not loaded: unexpected OTAPI version.");
        }
    }

    private static void loadBuildNo() {
        InputStream in = null;
        try {
            in = (class$wood$keith$opentools$buildnumber$BuildNumberNode == null ? (class$wood$keith$opentools$buildnumber$BuildNumberNode = BuildNumberNode.class$("wood.keith.opentools.buildnumber.BuildNumberNode")) : class$wood$keith$opentools$buildnumber$BuildNumberNode).getResourceAsStream("build.num");
            buildProps.load(in);
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        version = buildProps.getProperty("version");
        buildNo = buildProps.getProperty("build", "0");
    }

    public BuildNumberNode(Project project, Node node, Url url) throws DuplicateNodeException {
        super(project, node, url);
    }

    public Icon getDisplayIcon() {
        return BrowserIcons.ICON_REBUILD;
    }

    static void printAbout(byte major, byte minor) {
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("BuildNumberOT Version ").append(version).append(" (Build ").append(buildNo).append(")"))));
        System.out.println("  Copyright (c) 2001,2002, Joi Ellis.  All rights reserved.");
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("  JBuilder OTAPI Major.Minor: ").append(major).append(".").append(minor))));
        if (DEBUG) {
            System.out.println("  DEBUGGING OUTPUT ENABLED.");
        }
    }

    private static String test() {
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = (class$wood$keith$opentools$buildnumber$BuildNumberNode == null ? (class$wood$keith$opentools$buildnumber$BuildNumberNode = BuildNumberNode.class$("wood.keith.opentools.buildnumber.BuildNumberNode")) : class$wood$keith$opentools$buildnumber$BuildNumberNode).getResourceAsStream("build.num");
            props.load(in);
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props.getProperty("build", "0");
    }

    protected Properties getProps() throws Exception {
        Properties props = new Properties();
        InputStream in = this.getBuffer().getInputStream();
        props.load(in);
        in.close();
        return props;
    }

    protected void putProps(Properties buildNodeProps) throws IOException, ReadOnlyException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        buildNodeProps.store(baos, "Contents updated by BuildNumberOT");
        this.getBuffer().setContent(baos.toByteArray());
        this.getBuffer().save();
        baos.close();
    }

    protected void updateProps() throws Exception, ReadOnlyException, IOException {
        Properties props = this.getProps();
        BuildNumberNode.incrementProps(props);
        this.putProps(props);
    }

    protected static void setDefaults(Properties buildNodeProps) {
        buildNodeProps.setProperty("build", "0");
        buildNodeProps.setProperty("version", "0.0.0");
        buildNodeProps.setProperty("date", "");
        buildNodeProps.setProperty("epoch", "0");
        buildNodeProps.setProperty("prebuild", "");
        buildNodeProps.setProperty("postbuild", "");
        buildNodeProps.setProperty("comment", "");
        buildNodeProps.setProperty("disabled", "false");
    }

    protected static void incrementProps(Properties buildNodeProps) {
        int i = 0;
        if (((Hashtable)buildNodeProps).isEmpty()) {
            BuildNumberNode.setDefaults(buildNodeProps);
        }
        try {
            i = Integer.parseInt(buildNodeProps.getProperty("build", "0"));
            ++i;
        }
        catch (NumberFormatException nfe) {
            i = 0;
        }
        buildNodeProps.setProperty("build", Integer.toString(i));
        if (((Hashtable)buildNodeProps).containsKey("version")) {
            int buildCount = 0;
            String data = buildNodeProps.getProperty("version");
            i = data.lastIndexOf(".");
            String prefix = data.substring(0, i + 1);
            try {
                buildCount = Integer.parseInt(data.substring(i + 1));
            }
            catch (NumberFormatException nfe) {
                buildCount = 0;
            }
            buildNodeProps.setProperty("version", String.valueOf(String.valueOf(prefix)).concat(String.valueOf(String.valueOf(++buildCount))));
        }
        Date now = new Date();
        if (((Hashtable)buildNodeProps).containsKey("date")) {
            buildNodeProps.setProperty("date", now.toString());
        }
        if (((Hashtable)buildNodeProps).containsKey("epoch")) {
            buildNodeProps.setProperty("epoch", Long.toString(now.getTime()));
        }
    }

    protected static void blat(String text) {
        if (PrimeTime.isVerbose() && DEBUG) {
            System.out.println(text);
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        buildProps = new Properties();
    }
}

