package wood.keith.opentools.buildnumber;
import com.borland.jbuilder.build.ParseError;
import com.borland.primetime.build.BuildProcess;

import com.borland.primetime.build.BuildTask;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Project;
import com.borland.primetime.vfs.Buffer;
import com.borland.primetime.vfs.ReadOnlyException;
import com.borland.primetime.vfs.Url;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.io.InputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import com.borland.primetime.PrimeTime;

/**
 *  Title: Build Number OpenTool Description: This simple opentool
 *  provides a build number incremented automatically with each
 *  build/make. Copyright: Copyright (c) 2001
 *
 * @author     Joi Ellis
 * @created    July 11, 2001
 * @version    1.4A
 */

public class BuildNumberBuildTask extends BuildTask {
  /**
   *  Used by JB as a hash key, I think.
   */
  public final static String BUILD_TASK_KEY = "BuildNumber";
  /**
   *  Appears in the build status dialog box.
   */
  protected String compilingStatusMessage;
  /**
   *  Appears when there is a problem launching the build.
   */
  protected String invocationErrorMessage;

  /**
   *  Does the actual 'build' work of incrementing the build number
   *  node.
   *
   * @param  process  The current BuildProcess
   * @param  project  The project being built
   * @param  flag     If true, stop the build if there are errors(?)
   * @return          True if build should be terminated due to errors
   */

  String eol = System.getProperty( "line.separator" );
  /**
   *  Description of the Field
   */
  private ArrayList sourceFiles;


  /**
   *  Constructor for the BuildNumberBuildTask object
   */
  public BuildNumberBuildTask() {
    compilingStatusMessage = "Updating build number for {0}...";
    invocationErrorMessage = "Invocation Error.";
    sourceFiles = new ArrayList();
  }


  /**
   *  Adds a node's url to the list of things to be built.
   *
   * @param  url  The url of the node to be built.
   */
  public void addBuildSource( BuildNumberNode node ) {
    sourceFiles.add(node);
  }


  /**
   *  Description of the Method
   *
   * @param  process  Description of Parameter
   * @return          Description of the Returned Value
   */
  public boolean build( BuildProcess process ) {
    for ( int j = 0; j < sourceFiles.size() && !process.isCancelled(); j++ ) {
      buildOneNode( process, (BuildNumberNode) sourceFiles.get( j ) );
    }
    return true;
  }


  /**
   *  Builds a single node
   *
   * @param  process   Current BuildProcess
   * @param  filenode  BuildNumberNode file being built
   */
  private void buildOneNode( BuildProcess process, BuildNumberNode filenode ) {
    if ( filenode != null ) {
      process.fireBuildStatus(
        com.borland.primetime.util.Strings.format(
          compilingStatusMessage, filenode.getDisplayName()
         ),
        true
      );
      BuildNumberNode.blat("Building " + filenode.getDisplayName() );

      try {
        Properties nodeProps = filenode.getProps( );

        String toolDisabled = System.getProperty("BuildNumberOT.disabled","false");
        if ( isTrue ( toolDisabled ) ) {
            process.fireBuildProblem(
              filenode.getUrl(), false, filenode.getDisplayName() + ": BuildNumberOT is disabled.", 1, 1, null
            );
            return;
        }


        String nodeDisabled = nodeProps.getProperty("disabled", "false");
        if ( isTrue( nodeDisabled ) ) {
            process.fireBuildProblem(
              filenode.getUrl(), false, filenode.getDisplayName() + ": node is disabled.", 1, 1, null
            );
            return;
        }

        Buffer buffer = filenode.getBuffer();
        incrementLinesInBuffer( process, filenode );

      } catch ( IOException ioex ) {
        process.fireBuildProblem(
          filenode.getUrl(), true, ioex.getMessage(), 1, 1, null
        );
      } catch ( Exception ex ) {
        process.fireBuildProblem(
          filenode.getUrl(), true, ex.getMessage(), 1, 1, null
        );
      }
    }
  }

  private boolean isTrue( String value ) {
     return  ( value.equalsIgnoreCase("true") ||
               value.equalsIgnoreCase("yes")  ||
               value.equalsIgnoreCase("1") );

  }


  /**
   *  Opens a url and increments every line in the file.
   *
   * @param  process  Current Buildprocess
   * @param  thisUrl  Url of BuildNumberNode to increment
   * @param  buffer  Project being built
   */
  private void incrementLinesInBuffer( BuildProcess process, BuildNumberNode filenode ) {
    try {
      filenode.updateProps();

    } catch ( ReadOnlyException roex ) {
      process.fireBuildProblem(
        filenode.getUrl(), true, roex.getMessage(), 1, 1, null
      );
    } catch ( IOException ioex ) {
      process.fireBuildProblem(
        filenode.getUrl(), true, ioex.getMessage(), 1, 1, null
      );
    } catch ( Exception ex ) {
      process.fireBuildProblem(
        filenode.getUrl(), true, ex.getMessage(), 1, 1, null
      );
    }
  }
}
