package wood.keith.opentools.cmtdump;

import com.borland.jbuilder.JBuilderMenu;
import com.borland.jbuilder.cmt.CmtEventState;
import com.borland.jbuilder.cmt.CmtMethodCall;
import com.borland.jbuilder.cmt.CmtPropertyState;
import com.borland.jbuilder.cmt.CmtSubcomponent;
import com.borland.jbuilder.designer.DesignerViewer;
import com.borland.primetime.PrimeTime;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.BrowserAction;

/**
 * Demonstrate navigation through the CMT hierarchy in JBuilder.
 *
 * @author   Keith Wood (kbwood@iprimus\.com\.au)
 * @version  1.0  23 April 2002
 */
public class CMTDump extends BrowserAction {

  /**
   * Add the action to the menu.
   *
   * @param  majorVersion  the major version of the current OpenTools API
   * @param  minorVersion  the minor version of the current OpenTools API
   */
  public static void initOpenTool(byte majorVersion, byte minorVersion) {
    if (majorVersion != PrimeTime.CURRENT_MAJOR_VERSION) {
      return;
    }
    JBuilderMenu.GROUP_Tools.add(new CMTDump(false));
    JBuilderMenu.GROUP_Tools.add(new CMTDump(true));
  }

  private boolean full = false;
  /**
   * Initialise the action.
   *
   * @param  full  true to dump all attributes,
   *               false to just get the type and name
   */
  public CMTDump(boolean full) {
    super("CMT Dump - " + (full ? "Full" : "Short"), 'D',
      "Dump the " + (full ? "full" : "short") + " CMT hierarchy");
    this.full = full;
  }

  /**
   * Start dumping the CMT hierarchy for the current class.
   *
   * @param  browser  is the active browser
   */
  public void actionPerformed(Browser browser) {
    DesignerViewer viewer =
      (DesignerViewer)browser.getActiveViewer(browser.getActiveNode());
    CmtSubcomponent[] subcomps = viewer.getSubcomponents();
    for (int index = 0; index < subcomps.length; index++) {
      dumpComponent(subcomps[index]);
    }
  }

  /**
   * Dump the CMT details for the current class.
   *
   * @param  component  is the current component
   */
  private void dumpComponent(CmtSubcomponent component) {
    if (full) {
      System.out.println("--------------");
      System.out.println(component.getComponent().getLiveClazz().getName());
      // List properties and their settings
      System.out.println("Properties:");
      CmtPropertyState[] properties = component.getPropertyStates();
      for (int index = 0; index < properties.length; index++) {
        System.out.println("  " + properties[index].getProperty().getName() +
          " = " + properties[index].getValueText() +
          " | " + properties[index].getValue() +
          " | " + properties[index].getValueSource() +
          " | " + properties[index].isDefault() +
          " | " + properties[index].isPseudoPropertyState());
        if (properties[index].getPropertySetting() != null) {
          System.out.println("    Setting: " +
            properties[index].getPropertySetting().getValue() +
            " | " + properties[index].getPropertySetting().getValueSource() +
            " | " + properties[index].getPropertySetting().
            getMethodCall().getJotMethodCall().getText());
        }
      }
      // List events and their settings
      System.out.println("Events:");
      CmtEventState[] events = component.getEventStates();
      for (int index = 0; index < events.length; index++) {
        System.out.println("  " + events[index].getProperty().getName() +
          " = " + events[index].getValueText() +
          " | " + events[index].getValue() +
          " | " + events[index].getValueSource() +
          " | " + events[index].getDefaultHandlerText() +
          " | " + events[index].isDefault() +
          " | " + events[index].isPseudoPropertyState());
        if (events[index].getPropertySetting() != null) {
          System.out.println("    Setting: " +
            events[index].getPropertySetting().getValue() +
            " | " + events[index].getPropertySetting().getValueSource() +
            " | " + events[index].getPropertySetting().
            getMethodCall().getJotMethodCall().getText());
        }
      }
      // List other miscellaneous settings
      System.out.println("Other");
      System.out.println("  Assignment: " + (component.getAssignment() == null ?
        "null" : component.getAssignment().getText()));
      System.out.println("  Declared class: " +
        (component.getDeclaredClass() == null ? "null" :
        component.getDeclaredClass().getName()));
      System.out.println("  Default event state: " +
        (component.getDefaultEventState() == null ? "null" :
        component.getDefaultEventState().getProperty().getName() + " = " +
        component.getDefaultEventState().getValueText()));
      System.out.println("  Default property state: " +
        (component.getDefaultPropertyState() == null ? "null" :
        component.getDefaultPropertyState().getProperty().getName() + " = " +
        component.getDefaultPropertyState().getValueText()));
      System.out.println("  Initializer: " + (component.getInitializer() == null ?
        "null" : component.getInitializer().getText()));
      System.out.println("  InitMethod: " +
        (component.getInitMethod() == null ? "null" :
        component.getInitMethod().getJotMethodSource().getCodeBlock().getText()));
      System.out.println("  LiveClass: " + component.getLiveClass().getName());
      System.out.println("  LiveInstance: " + component.getLiveInstance(true));
      CmtMethodCall[] calls = component.getMethodCalls();
      for (int index = 0; index < calls.length; index++) {
        System.out.println("  MethodCall " + index + ": " +
          calls[index].getJotMethodCall().getText());
      }
      System.out.println("  Name: " + component.getName());
      System.out.println("  OuterComponent: " +
        (component.getOuterComponent() == null ? "null" :
        component.getOuterComponent().getName()));
      System.out.println("  Scope: " + component.getScope());
      System.out.println("  SourceName: " + component.getSourceName());
    }
    else {
      // For short form, just list type and name
      System.out.println(component.getComponent().getLiveClazz().getName() +
        " " + component.getName());
    }
  }

  /**
   * Alter the enabled/disabled setting for this action.
   *
   * @param  browser  is the active browser
   */
  public void update(Browser browser) {
    setEnabled(browser.getActiveViewer(browser.getActiveNode())
      instanceof DesignerViewer);
  }
}