/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.consoledisplay;

import com.borland.primetime.Command;
import com.borland.primetime.PrimeTime;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.BrowserAdapter;
import com.borland.primetime.ide.BrowserListener;
import java.io.PrintStream;
import wood.keith.opentools.consoledisplay.MessageOutputStream;

public class ConsoleDisplay
implements Command {
    private static final String DESCR = "Redirect console output to a message view";
    private static final String LEADER = "ConsoleDisplay: ";
    private static final String USAGE = "  Redirects the normal console output to a tab in the message pane.\n  Optional parameters let you direct just normal output or just\n  error output. The default is to send both.\n  The name of the message tab reflects the parameter selection.\n\n  -consoledisp [out | err]";
    private static final String VERSION = "2.0";

    public String getCommandDescription() {
        return DESCR;
    }

    public static void initOpenTool(byte majorVersion, byte minorVersion) {
        if (majorVersion != 4) {
            return;
        }
        PrimeTime.registerCommand((String)"consoledisp", (Command)new ConsoleDisplay());
        if (PrimeTime.isVerbose()) {
            System.out.println("Loaded consoledisp command v2.0");
            System.out.println("Written by Keith Wood (kbwood@iprimus.com.au)");
        }
    }

    public void invokeCommand(String[] params) {
        boolean redirectErr;
        if (params.length > 1) {
            System.out.println("ConsoleDisplay:   Redirects the normal console output to a tab in the message pane.\n  Optional parameters let you direct just normal output or just\n  error output. The default is to send both.\n  The name of the message tab reflects the parameter selection.\n\n  -consoledisp [out | err]");
            return;
        }
        String param = "";
        if (params.length == 1 && !(param = params[0]).equals("out") && !param.equals("err")) {
            System.err.println("ConsoleDisplay:   Redirects the normal console output to a tab in the message pane.\n  Optional parameters let you direct just normal output or just\n  error output. The default is to send both.\n  The name of the message tab reflects the parameter selection.\n\n  -consoledisp [out | err]");
            return;
        }
        boolean redirectOut = !param.equals("err");
        boolean bl = redirectErr = !param.equals("out");
        final MessageOutputStream msgOut = new MessageOutputStream(!redirectOut ? "Err" : (!redirectErr ? "Out" : "Console"));
        PrintStream out = new PrintStream(msgOut);
        if (redirectOut) {
            System.setOut(out);
        }
        if (redirectErr) {
            System.setErr(out);
        }
        Browser.addStaticBrowserListener((BrowserListener)new BrowserAdapter(){

            public void browserOpened(Browser browser) {
                Browser.removeStaticBrowserListener((BrowserListener)this);
                msgOut.opened();
            }
        });
    }

    public void printCommandHelp(PrintStream out) {
        out.println(USAGE);
    }

    public boolean takesCommandArguments() {
        return true;
    }
}

