/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.consoledisplay;

import com.borland.jbuilder.node.JBProject;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.Message;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.TextFileNode;
import com.borland.primetime.vfs.Url;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class ConsoleMessage
extends Message
implements ActionListener {
    public ConsoleMessage(String text) {
        super(text);
        this.setMessageAction(this);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (!command.trim().startsWith("at") || !command.endsWith(")")) {
            return;
        }
        int pos = command.indexOf("(");
        if (pos == -1) {
            return;
        }
        String classRef = command.substring(7, pos);
        pos = (classRef = classRef.substring(0, classRef.lastIndexOf("."))).indexOf("$");
        if (pos != -1) {
            classRef = classRef.substring(0, pos);
        }
        classRef = classRef.replace('.', '/') + ".java";
        Browser browser = (Browser)e.getSource();
        JBProject project = (JBProject)browser.getActiveProject();
        Url url = project.findSourcePathUrl(classRef);
        if (url == null && (url = project.findClassPathUrl(classRef)) == null) {
            browser.getStatusView().setText("Can't find " + classRef);
            return;
        }
        FileNode node = project.getNode(url);
        if (node == null) {
            browser.getStatusView().setText("Can't open " + classRef);
            return;
        }
        try {
            browser.openNodes(new Node[]{node}, (Node)node);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        int line = -1;
        pos = command.indexOf(":");
        if (pos != -1) {
            try {
                line = Integer.parseInt(command.substring(pos + 1, command.length() - 1));
            }
            catch (NumberFormatException nfe) {
            }
        }
        if (line != -1 && node instanceof TextFileNode) {
            ((TextFileNode)node).setCaretPosition(line, 1, true);
        }
    }
}

