/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.consoledisplay;

import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.Message;
import com.borland.primetime.ide.MessageCategory;
import com.borland.primetime.ide.MessageView;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import wood.keith.opentools.consoledisplay.ConsoleMessage;

class MessageOutputStream
extends OutputStream {
    private static final int MIN_SIZE = 80;
    private StringBuffer buffer = new StringBuffer(80);
    private MessageCategory mcat;
    private MessageView mview = null;

    public MessageOutputStream(String category) {
        this.mcat = new MessageCategory(category);
    }

    private MessageView getView() {
        Browser browser;
        if (this.mview == null && (browser = Browser.getActiveBrowser()) != null) {
            this.mview = browser.getMessageView();
        }
        return this.mview;
    }

    public void opened() {
        try {
            this.write(10);
        }
        catch (IOException ex) {
        }
    }

    public void write(int b) throws IOException {
        switch (b) {
            case 10: {
                MessageView view = this.getView();
                if (view == null) {
                    this.buffer.append("\n");
                    break;
                }
                StringTokenizer tokens = new StringTokenizer(this.buffer.toString(), "\n");
                while (tokens.hasMoreTokens()) {
                    view.addMessage(this.mcat, (Message)new ConsoleMessage(tokens.nextToken()));
                }
                this.buffer.setLength(0);
                this.buffer.ensureCapacity(80);
                break;
            }
            case 13: {
                break;
            }
            case 9: {
                this.buffer.append("    ");
                break;
            }
            default: {
                this.buffer.append((char)b);
            }
        }
    }
}

