package wood.keith.opentools.firstot;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

import com.borland.jbuilder.JBuilderMenu;
import com.borland.primetime.PrimeTime;
import com.borland.primetime.actions.UpdateAction;

/**
 * Demonstration of the basics of an OpenTool.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  26 September 2001
 */
public class FirstOpenTool {

  /**
   * The static method invoked by JBuilder to initialise the OpenTool.
   *
   * @param  majorVersion  the major version of the current OpenTools API
   * @param  minorVersion  the minor version of the current OpenTools API
   */
  public static void initOpenTool(byte majorVersion, byte minorVersion) {

    // Check the OpenTools API version
    if (majorVersion != PrimeTime.CURRENT_MAJOR_VERSION) {
      return;
    }

    // Add an entry to the Tools menu
    JBuilderMenu.GROUP_Tools.add(new UpdateAction("Welcome") {
      public void actionPerformed(ActionEvent event) {
        JOptionPane.showMessageDialog(null, "Welcome to the OpenTools API",
            "JBuilder OpenTools", JOptionPane.INFORMATION_MESSAGE);
      }
    });

    // Provide initialisation details if requested
    if (PrimeTime.isVerbose()) {
      System.out.println("Loaded FirstOpenTool");
      System.out.println("Compiled version " + PrimeTime.CURRENT_MAJOR_VERSION +
          "." + PrimeTime.CURRENT_MINOR_VERSION);
      System.out.println("Runtime version  " + majorVersion +
          "." + minorVersion);
    }
  }
}
