/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.gifeditor;

import com.borland.primetime.actions.UpdateAction;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import wood.keith.opentools.gifeditor.ColorTracker;
import wood.keith.opentools.gifeditor.PixelEditor;
import wood.keith.opentools.gifeditor.TransparentChooser;

public class ColorAction
extends UpdateAction {
    private Color color = Color.red;
    private PixelEditor editor = null;
    private boolean isForeground = false;

    public ColorAction(PixelEditor editor, boolean isForeground) {
        super(isForeground ? "Foreground" : "Background");
        this.editor = editor;
        this.isForeground = isForeground;
        this.setColor(isForeground ? Color.black : Color.white);
        this.updateEditor();
    }

    public void actionPerformed(ActionEvent event) {
        JColorChooser chooser = new JColorChooser(this.color);
        chooser.addChooserPanel(new TransparentChooser());
        ColorTracker ok = new ColorTracker(chooser);
        JDialog dialog = JColorChooser.createDialog(this.editor, this.isForeground ? "Select foreground colour" : "Select background colour", true, chooser, ok, null);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                e.getWindow().hide();
            }
        });
        dialog.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                ((Window)e.getComponent()).dispose();
            }
        });
        dialog.show();
        if (ok.getColor() == null) {
            return;
        }
        this.setColor(ok.getColor());
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (this.color.equals(color)) {
            return;
        }
        this.color = color;
        BufferedImage image = new BufferedImage(16, 16, 2);
        Graphics g = image.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, 16, 16);
        if (color == PixelEditor.TRANSPARENT) {
            g.setColor(Color.black);
            g.drawLine(8, 8, 8, 8);
        }
        this.setSmallIcon(new ImageIcon(image));
        this.updateEditor();
    }

    public void update(Object source) {
        this.setColor(this.isForeground ? this.editor.getFGColor() : this.editor.getBGColor());
    }

    private void updateEditor() {
        if (this.isForeground) {
            this.editor.setFGColor(this.getColor());
        } else {
            this.editor.setBGColor(this.getColor());
        }
    }
}

