/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.gifeditor;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.borland.primetime.help.HelpManager;
import com.borland.primetime.help.HelpTopic;
import com.borland.primetime.help.ZipHelpBook;
import com.borland.primetime.help.ZipHelpTopic;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.StatusView;
import com.borland.primetime.node.ImageFileNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import wood.keith.opentools.gifeditor.ActionConstants;
import wood.keith.opentools.gifeditor.ColorAction;
import wood.keith.opentools.gifeditor.DrawConstants;
import wood.keith.opentools.gifeditor.ImageOps;
import wood.keith.opentools.gifeditor.OperationAction;
import wood.keith.opentools.gifeditor.PixelEditor;
import wood.keith.opentools.gifeditor.ResizeDialog;
import wood.keith.opentools.gifeditor.ToolAction;

public class GIFEditor
extends JPanel
implements ActionConstants,
DrawConstants,
PropertyChangeListener,
SwingConstants {
    private static final Dimension BUTTON_SIZE = new Dimension(23, 23);
    private static final int CELL_SIZE = 16;
    private ColorAction backgroundAction = null;
    private BorderLayout borderLayout = new BorderLayout();
    private ButtonGroup colorsGroup;
    private PixelEditor editor;
    private JScrollPane editorScroll;
    private ColorAction foregroundAction = null;
    private Action helpAction;
    private final ImageOps imageOps;
    private JToolBar operationsToolbar;
    private Action resetAction;
    private Action saveAction;
    private StatusView status;
    private JPanel toolbarPanel = new JPanel();
    private ButtonGroup toolsGroup;
    private JToolBar toolsToolbar;
    private VerticalFlowLayout verticalFlowLayout = new VerticalFlowLayout();
    private Action zoomInAction;
    private Action zoomOutAction;

    public GIFEditor(ImageFileNode node) {
        this.operationsToolbar = new JToolBar();
        this.toolsToolbar = new JToolBar();
        this.editorScroll = new JScrollPane();
        this.editor = new PixelEditor(null, 16);
        this.imageOps = new ImageOps();
        this.status = Browser.getActiveBrowser().getStatusView();
        this.toolsGroup = new ButtonGroup();
        this.colorsGroup = new ButtonGroup();
        this.resetAction = new OperationAction(this.editor, "ResetFile", "Reset image"){

            public void actionPerformed(ActionEvent event) {
                this.editor.resetNode();
            }
        };
        this.saveAction = new OperationAction(this.editor, "SaveFile", "Save image"){

            public void actionPerformed(ActionEvent event) {
                this.editor.saveNode();
            }
        };
        this.zoomInAction = new OperationAction(this.editor, "ZoomIn", "Zoom in"){

            public void actionPerformed(ActionEvent event) {
                this.editor.setCellSize(this.editor.getCellSize() * 2);
            }
        };
        this.zoomOutAction = new OperationAction(this.editor, "ZoomOut", "Zoom out"){

            public void actionPerformed(ActionEvent event) {
                this.editor.setCellSize(this.editor.getCellSize() / 2);
            }
        };
        this.helpAction = new OperationAction(this.editor, "Help", "Help"){

            public void actionPerformed(ActionEvent event) {
                HelpManager.showHelp((HelpTopic)new ZipHelpTopic(new ZipHelpBook("GIFEditorDoc.jar"), this.getClass().getPackage().getName().replace('.', '/') + "/GIFEditor.html"));
            }
        };
        try {
            this.jbInit();
            this.editor.setNode(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.editor.addPropertyChangeListener(propertyName, listener);
    }

    private void addToggleButton(JToolBar toolbar, ButtonGroup group, Action action) {
        JToggleButton button = new JToggleButton(action);
        button.setPreferredSize(BUTTON_SIZE);
        button.setMaximumSize(BUTTON_SIZE);
        button.setSelected(group.getButtonCount() == 0);
        group.add(button);
        toolbar.add(button);
    }

    private void enableToolbarButtons(JToolBar toolbar, boolean value) {
        int index = 0;
        while (index < toolbar.getComponentCount()) {
            if (toolbar.getComponent(index) instanceof AbstractButton) {
                ((AbstractButton)toolbar.getComponent(index)).getAction().setEnabled(value);
            }
            ++index;
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout);
        this.toolbarPanel.setLayout((LayoutManager)this.verticalFlowLayout);
        this.verticalFlowLayout.setHgap(0);
        this.verticalFlowLayout.setVgap(0);
        this.operationsToolbar.setName("Image operations");
        this.toolsToolbar.setName("Drawing tools");
        this.add((Component)this.editorScroll, "Center");
        this.add((Component)this.toolbarPanel, "North");
        this.toolbarPanel.add((Component)this.operationsToolbar, null);
        this.toolbarPanel.add((Component)this.toolsToolbar, null);
        this.editorScroll.getViewport().add((Component)this.editor, null);
        this.editor.addPropertyChangeListener(this);
        this.operationsToolbar.add(new OperationAction(this.editor, "RotateLeft", "Rotate anticlockwise"){

            public void actionPerformed(ActionEvent event) {
                this.editor.setImage(GIFEditor.this.imageOps.rotateImage(this.editor.getImage(), 2));
            }
        });
        this.operationsToolbar.add(new OperationAction(this.editor, "RotateRight", "Rotate clockwise"){

            public void actionPerformed(ActionEvent event) {
                this.editor.setImage(GIFEditor.this.imageOps.rotateImage(this.editor.getImage(), 4));
            }
        });
        this.operationsToolbar.add(new OperationAction(this.editor, "FlipVert", "Flip vertically"){

            public void actionPerformed(ActionEvent event) {
                this.editor.setImage(GIFEditor.this.imageOps.flipImage(this.editor.getImage(), 1));
            }
        });
        this.operationsToolbar.add(new OperationAction(this.editor, "FlipHorz", "Flip horizontally"){

            public void actionPerformed(ActionEvent event) {
                this.editor.setImage(GIFEditor.this.imageOps.flipImage(this.editor.getImage(), 0));
            }
        });
        this.operationsToolbar.addSeparator();
        this.operationsToolbar.add(new OperationAction(this.editor, "MoveNorthWest", "Move up and left"){

            public void actionPerformed(ActionEvent event) {
                this.editor.setImage(GIFEditor.this.imageOps.moveImage(this.editor.getImage(), -1, -1));
            }
        });
        this.operationsToolbar.add(new OperationAction(this.editor, "MoveNorth", "Move up"){

            public void actionPerformed(ActionEvent event) {
                this.editor.setImage(GIFEditor.this.imageOps.moveImage(this.editor.getImage(), 0, -1));
            }
        });
        this.operationsToolbar.add(new OperationAction(this.editor, "MoveNorthEast", "Move up and right"){

            public void actionPerformed(ActionEvent event) {
                this.editor.setImage(GIFEditor.this.imageOps.moveImage(this.editor.getImage(), 1, -1));
            }
        });
        this.operationsToolbar.add(new OperationAction(this.editor, "MoveWest", "Move left"){

            public void actionPerformed(ActionEvent event) {
                this.editor.setImage(GIFEditor.this.imageOps.moveImage(this.editor.getImage(), -1, 0));
            }
        });
        this.operationsToolbar.add(new OperationAction(this.editor, "MoveEast", "Move right"){

            public void actionPerformed(ActionEvent event) {
                this.editor.setImage(GIFEditor.this.imageOps.moveImage(this.editor.getImage(), 1, 0));
            }
        });
        this.operationsToolbar.add(new OperationAction(this.editor, "MoveSouthWest", "Move down and left"){

            public void actionPerformed(ActionEvent event) {
                this.editor.setImage(GIFEditor.this.imageOps.moveImage(this.editor.getImage(), -1, 1));
            }
        });
        this.operationsToolbar.add(new OperationAction(this.editor, "MoveSouth", "Move down"){

            public void actionPerformed(ActionEvent event) {
                this.editor.setImage(GIFEditor.this.imageOps.moveImage(this.editor.getImage(), 0, 1));
            }
        });
        this.operationsToolbar.add(new OperationAction(this.editor, "MoveSouthEast", "Move down and right"){

            public void actionPerformed(ActionEvent event) {
                this.editor.setImage(GIFEditor.this.imageOps.moveImage(this.editor.getImage(), 1, 1));
            }
        });
        this.operationsToolbar.addSeparator();
        this.operationsToolbar.add(this.zoomInAction);
        this.operationsToolbar.add(this.zoomOutAction);
        this.operationsToolbar.addSeparator();
        this.operationsToolbar.add(this.saveAction);
        this.operationsToolbar.add(this.resetAction);
        this.operationsToolbar.add(new OperationAction(this.editor, "Resize", "Resize image"){

            public void actionPerformed(ActionEvent event) {
                ResizeDialog resize = new ResizeDialog(this.editor.image.getWidth(), this.editor.image.getHeight());
                if (!resize.isCancelled()) {
                    this.editor.resizeImage(resize.getWidth(), resize.getHeight());
                }
            }
        });
        this.operationsToolbar.addSeparator();
        this.operationsToolbar.add(this.helpAction);
        this.addToggleButton(this.toolsToolbar, this.toolsGroup, (Action)((Object)new ToolAction(this.editor, "Hand", new Point(8, 8), "Move")));
        this.addToggleButton(this.toolsToolbar, this.toolsGroup, (Action)((Object)new ToolAction(this.editor, "Cut", new Point(2, 2), "Cut")));
        this.addToggleButton(this.toolsToolbar, this.toolsGroup, (Action)((Object)new ToolAction(this.editor, "Copy", new Point(2, 2), "Copy")));
        this.addToggleButton(this.toolsToolbar, this.toolsGroup, (Action)((Object)new ToolAction(this.editor, "Paste", new Point(2, 2), "Paste")));
        this.toolsToolbar.addSeparator();
        this.addToggleButton(this.toolsToolbar, this.toolsGroup, (Action)((Object)new ToolAction(this.editor, "Pencil", new Point(4, 15), "Draw")));
        this.addToggleButton(this.toolsToolbar, this.toolsGroup, (Action)((Object)new ToolAction(this.editor, "Dropper", new Point(0, 15), "Pickup colour")));
        this.addToggleButton(this.toolsToolbar, this.toolsGroup, (Action)((Object)new ToolAction(this.editor, "Paint", new Point(13, 14), "Fill")));
        this.addToggleButton(this.toolsToolbar, this.toolsGroup, (Action)((Object)new ToolAction(this.editor, "Line", new Point(0, 0), "Line")));
        this.addToggleButton(this.toolsToolbar, this.toolsGroup, (Action)((Object)new ToolAction(this.editor, "Oval", new Point(0, 0), "Oval")));
        this.addToggleButton(this.toolsToolbar, this.toolsGroup, (Action)((Object)new ToolAction(this.editor, "Rect", new Point(0, 0), "Rectangle")));
        this.addToggleButton(this.toolsToolbar, this.toolsGroup, (Action)((Object)new ToolAction(this.editor, "RoundRect", new Point(0, 0), "Rounded rectangle")));
        this.addToggleButton(this.toolsToolbar, this.toolsGroup, (Action)((Object)new ToolAction(this.editor, "FillOval", new Point(0, 0), "Filled oval")));
        this.addToggleButton(this.toolsToolbar, this.toolsGroup, (Action)((Object)new ToolAction(this.editor, "FillRect", new Point(0, 0), "Filled rectangle")));
        this.addToggleButton(this.toolsToolbar, this.toolsGroup, (Action)((Object)new ToolAction(this.editor, "FillRoundRect", new Point(0, 0), "Filled rounded rectangle")));
        this.addToggleButton(this.toolsToolbar, this.toolsGroup, (Action)((Object)new ToolAction(this.editor, "Transpose", new Point(0, 0), "Transpose colours")));
        this.toolsToolbar.addSeparator();
        this.foregroundAction = new ColorAction(this.editor, true);
        JButton button = new JButton((Action)((Object)this.foregroundAction));
        button.setPreferredSize(BUTTON_SIZE);
        button.setMaximumSize(BUTTON_SIZE);
        this.toolsToolbar.add(button);
        button = new JButton(new SwapColorsAction());
        button.setPreferredSize(BUTTON_SIZE);
        button.setMaximumSize(BUTTON_SIZE);
        this.toolsToolbar.add(button);
        this.backgroundAction = new ColorAction(this.editor, false);
        button = new JButton((Action)((Object)this.backgroundAction));
        button.setPreferredSize(BUTTON_SIZE);
        button.setMaximumSize(BUTTON_SIZE);
        this.toolsToolbar.add(button);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("Coords")) {
            Point point = (Point)event.getNewValue();
            this.status.setHintText("GIF Editor " + (int)point.getX() + "," + (int)point.getY());
        } else if (event.getPropertyName().equals("Color")) {
            this.foregroundAction.update(this.editor);
            this.backgroundAction.update(this.editor);
        } else if (event.getPropertyName().equals("Image")) {
            this.enableToolbarButtons(this.operationsToolbar, !this.editor.isReadOnly());
            this.zoomInAction.setEnabled(true);
            this.zoomOutAction.setEnabled(true);
            this.saveAction.setEnabled(this.editor.isModified());
            this.resetAction.setEnabled(this.editor.isModified());
            this.helpAction.setEnabled(true);
            this.enableToolbarButtons(this.toolsToolbar, !this.editor.isReadOnly());
        } else if (event.getPropertyName().equals("Tool")) {
            Enumeration<AbstractButton> enumeration = this.toolsGroup.getElements();
            while (enumeration.hasMoreElements()) {
                JToggleButton button = (JToggleButton)enumeration.nextElement();
                ToolAction action = (ToolAction)((Object)button.getAction());
                if (!action.getToolName().equals(event.getNewValue())) continue;
                this.toolsGroup.setSelected(button.getModel(), true);
                action.setState(this.editor, true);
                button.repaint();
                break;
            }
        }
    }

    class SwapColorsAction
    extends AbstractAction {
        public SwapColorsAction() {
            super("");
            this.putValue("SmallIcon", new ImageIcon(ClassLoader.getSystemResource("wood/keith/opentools/gifeditor/SwapColorsIcon.gif")));
            this.putValue("ShortDescription", "Swap background/foreground");
        }

        public void actionPerformed(ActionEvent event) {
            Color temp = GIFEditor.this.backgroundAction.getColor();
            GIFEditor.this.backgroundAction.setColor(GIFEditor.this.foregroundAction.getColor());
            GIFEditor.this.foregroundAction.setColor(temp);
        }
    }
}

