/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.gifeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import wood.keith.opentools.gifeditor.GIFEditor;

public class GIFEditorStructure
extends JScrollPane
implements PropertyChangeListener {
    private static final int INSET = 10;
    private JLabel imageLabel = new JLabel();
    private TitledBorder titledBorder;

    public GIFEditorStructure(GIFEditor gifEditor) {
        try {
            this.jbInit();
            gifEditor.addPropertyChangeListener("Image", this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(new Color(188, 255, 198), new Color(92, 128, 97)), "Preview");
        this.imageLabel.setHorizontalAlignment(0);
        this.setBorder(this.titledBorder);
        this.getViewport().add((Component)this.imageLabel, null);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("Image")) {
            BufferedImage image = (BufferedImage)evt.getNewValue();
            this.imageLabel.setIcon(new ImageIcon(image));
            this.imageLabel.setPreferredSize(new Dimension(image.getWidth() + 10, image.getHeight() + 10));
            this.titledBorder.setTitle("Preview (" + image.getWidth() + "x" + image.getHeight() + ")");
            this.repaint();
        }
    }
}

