/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.gifeditor;

import Acme.JPM.Encoders.GifEncoder;
import com.borland.primetime.node.ImageFileNode;
import com.borland.primetime.vfs.Buffer;
import com.borland.primetime.vfs.BufferListener;
import com.borland.primetime.vfs.BufferUpdater;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.border.EmptyBorder;
import wood.keith.opentools.gifeditor.ActionConstants;
import wood.keith.opentools.gifeditor.DrawConstants;
import wood.keith.opentools.gifeditor.ImageOps;
import wood.keith.opentools.gifeditor.ImageSelection;
import wood.keith.opentools.gifeditor.PixelView;

public class PixelEditor
extends PixelView
implements DrawConstants,
ActionConstants,
MouseListener,
MouseMotionListener,
BufferListener,
BufferUpdater {
    public static final String COLOR_PROP = "Color";
    public static final String COORDS_PROP = "Coords";
    public static final String IMAGE_PROP = "Image";
    public static final String TOOL_PROP = "Tool";
    protected static final Color TRANSPARENT;
    protected static final Color TRANSPARENT_SHOW;
    protected String activeTool = "Pencil";
    protected boolean antiAliased = false;
    protected Color bgColor;
    public static final Clipboard clipboard;
    protected Color curColor;
    protected Rectangle drag;
    protected Color fgColor = Color.black;
    protected ImageFileNode imageNode = null;
    protected ImageOps imageOps;
    protected String lastTool = "None";
    protected boolean modified = false;
    protected BufferedImage move;
    private Point point;
    protected boolean readonly = false;

    static {
        clipboard = new Clipboard("GIFEditor");
        TRANSPARENT = new Color(0, true);
        TRANSPARENT_SHOW = new Color(126, 125, 128);
    }

    public PixelEditor(BufferedImage image, int cellSize) {
        super(image, cellSize);
        this.bgColor = TRANSPARENT;
        this.curColor = this.fgColor;
        this.point = new Point(0, 0);
        this.imageOps = new ImageOps();
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.addPropertyChangeListener(propertyName, listener);
        if (propertyName.equals(IMAGE_PROP)) {
            this.firePropertyChange(IMAGE_PROP, null, this.image);
        }
    }

    private Rectangle adjustDrag(Rectangle drag) {
        Rectangle adjusted = (Rectangle)drag.clone();
        if (adjusted.width < 0) {
            adjusted.x += adjusted.width;
            adjusted.width = -adjusted.width;
        }
        if (adjusted.height < 0) {
            adjusted.y += adjusted.height;
            adjusted.height = -adjusted.height;
        }
        return adjusted;
    }

    public void bufferChanged(Buffer buffer, BufferUpdater updater) {
        if (updater != this) {
            this.loadImage(buffer);
        }
    }

    public void bufferLoaded(Buffer buffer) {
    }

    public void bufferSaving(Buffer buffer) {
    }

    public void bufferStateChanged(Buffer buffer, int oldState, int newState) {
        this.setReadOnly((2 & newState) > 0);
    }

    private void checkForTransparency() {
        if (this.curColor != TRANSPARENT) {
            return;
        }
        int x = 0;
        while (x < this.drag.width + 1) {
            if (this.drag.x + x >= 0 && this.drag.x + x < this.image.getWidth()) {
                int y = 0;
                while (y < this.drag.height + 1) {
                    if (this.drag.y + y >= 0 && this.drag.y + y < this.image.getHeight() && this.image.getRGB(this.drag.x + x, this.drag.y + y) == TRANSPARENT_SHOW.getRGB()) {
                        this.image.setRGB(this.drag.x + x, this.drag.y + y, TRANSPARENT.getRGB());
                    }
                    ++y;
                }
            }
            ++x;
        }
    }

    protected void drawSelection(Graphics g, Insets insets) {
        g.setColor(this.curColor == TRANSPARENT ? TRANSPARENT_SHOW : this.curColor);
        int halfCell = this.cellSize / 2;
        int corner = this.cellSize * 3;
        Rectangle scaled = new Rectangle(insets.left + this.drag.x * this.cellSize + halfCell, insets.top + this.drag.y * this.cellSize + halfCell, this.drag.width * this.cellSize, this.drag.height * this.cellSize);
        if (!this.activeTool.equals("Line")) {
            scaled = this.adjustDrag(scaled);
        }
        if (this.activeTool.equals("Line")) {
            g.drawLine(scaled.x, scaled.y, scaled.x + scaled.width, scaled.y + scaled.height);
        } else if (this.activeTool.equals("FillOval")) {
            g.fillOval(scaled.x, scaled.y, scaled.width, scaled.height);
        } else if (this.activeTool.equals("Oval") || this.activeTool.equals("FillOval")) {
            g.drawOval(scaled.x, scaled.y, scaled.width, scaled.height);
        } else if (this.activeTool.equals("FillRect")) {
            g.fillRect(scaled.x, scaled.y, scaled.width, scaled.height);
        } else if (this.activeTool.equals("Rect") || this.activeTool.equals("Transpose") || this.activeTool.equals("Cut") || this.activeTool.equals("Copy") || this.activeTool.equals("Paste")) {
            g.drawRect(scaled.x, scaled.y, scaled.width, scaled.height);
        } else if (this.activeTool.equals("FillRoundRect")) {
            g.fillRoundRect(scaled.x, scaled.y, scaled.width, scaled.height, corner, corner);
        } else if (this.activeTool.equals("RoundRect")) {
            g.drawRoundRect(scaled.x, scaled.y, scaled.width, scaled.height, corner, corner);
        }
    }

    public Color getBGColor() {
        return this.bgColor;
    }

    public byte[] getBufferContent(Buffer buffer) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            new GifEncoder(this.image, (OutputStream)out).encode();
            return out.toByteArray();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return new byte[]{0};
        }
    }

    public Color getFGColor() {
        return this.fgColor;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public String getToolName() {
        return this.activeTool;
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    private boolean isForeground(MouseEvent event) {
        return (event.getModifiers() & 0x10) != 0;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public void loadImage(Buffer buffer) {
        Image img = new ImageIcon(buffer.getBufferContent(buffer)).getImage();
        this.image = new BufferedImage(img.getWidth(null) == -1 ? 16 : img.getWidth(null), img.getHeight(null) == -1 ? 16 : img.getHeight(null), 2);
        Graphics g = this.image.getGraphics();
        g.drawImage(img, 0, 0, null);
        this.repaint();
        this.setModified(false);
    }

    public void loadImage() {
        try {
            this.loadImage(this.imageNode.getBuffer());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseDragged(MouseEvent event) {
        this.mouseMoved(event);
        this.curColor = this.isForeground(event) ? this.fgColor : this.bgColor;
        int x = (int)this.point.getX();
        int y = (int)this.point.getY();
        if (this.move != null) {
            this.image = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 2);
            Graphics g = this.image.getGraphics();
            g.drawImage(this.move, x - this.drag.x, y - this.drag.y, this);
            this.setModified(true);
        }
        if (this.drag != null) {
            this.drag.setSize(x - this.drag.x, y - this.drag.y);
            this.repaint();
        }
        if (x < 0 || x >= this.image.getWidth() || y < 0 || y >= this.image.getHeight()) {
            return;
        }
        if (this.activeTool.equals("Pencil")) {
            this.image.setRGB(x, y, this.curColor.getRGB());
            this.setModified(true);
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mouseMoved(MouseEvent event) {
        Insets insets = this.getInsets();
        int x = (event.getX() - insets.left) / this.cellSize;
        int y = (event.getY() - insets.top) / this.cellSize;
        this.point.setLocation(x, y);
        if (x >= 0 && x < this.image.getWidth() && y >= 0 && y < this.image.getHeight()) {
            this.firePropertyChange(COORDS_PROP, null, this.point);
        }
    }

    public void mousePressed(MouseEvent event) {
        Insets insets = this.getInsets();
        int x = (event.getX() - insets.left) / this.cellSize;
        int y = (event.getY() - insets.top) / this.cellSize;
        if (x < 0 || x >= this.image.getWidth() || y < 0 || y >= this.image.getHeight()) {
            return;
        }
        Color color = this.curColor = this.isForeground(event) ? this.fgColor : this.bgColor;
        if (this.activeTool.equals("Pencil")) {
            this.image.setRGB(x, y, this.curColor.getRGB());
            this.setModified(true);
        } else if (this.activeTool.equals("Dropper")) {
            Color newColor;
            Color color2 = newColor = this.image.getRGB(x, y) == TRANSPARENT.getRGB() ? TRANSPARENT : new Color(this.image.getRGB(x, y));
            if (this.isForeground(event)) {
                this.fgColor = newColor;
            } else {
                this.bgColor = newColor;
            }
            this.firePropertyChange(COLOR_PROP, this.curColor, newColor);
        } else if (this.activeTool.equals("Paint")) {
            this.imageOps.floodFill(this.image, x, y, this.image.getRGB(x, y), this.curColor.getRGB());
            this.setModified(true);
        } else if (this.activeTool.equals("Pencil") || this.activeTool.equals("Line") || this.activeTool.equals("Oval") || this.activeTool.equals("FillOval") || this.activeTool.equals("Rect") || this.activeTool.equals("FillRect") || this.activeTool.equals("RoundRect") || this.activeTool.equals("FillRoundRect") || this.activeTool.equals("Transpose") || this.activeTool.equals("Cut") || this.activeTool.equals("Copy") || this.activeTool.equals("Paste")) {
            this.drag = new Rectangle(x, y, 0, 0);
        } else if (this.activeTool.equals("Hand")) {
            this.move = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 2);
            Graphics g = this.move.getGraphics();
            g.drawImage(this.image, 0, 0, this);
            this.drag = new Rectangle(x, y, 0, 0);
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent event) {
        if (this.activeTool.equals("Dropper")) {
            this.setToolName(this.lastTool);
        } else if (this.drag != null) {
            if (!this.activeTool.equals("Line")) {
                this.drag = this.adjustDrag(this.drag);
            }
            Graphics2D g = (Graphics2D)this.image.getGraphics();
            this.curColor = this.isForeground(event) ? this.fgColor : this.bgColor;
            g.setColor(this.curColor == TRANSPARENT ? TRANSPARENT_SHOW : this.curColor);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antiAliased ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            boolean modified = true;
            if (this.activeTool.equals("Line")) {
                g.drawLine(this.drag.x, this.drag.y, this.drag.x + this.drag.width, this.drag.y + this.drag.height);
            } else if (this.activeTool.equals("FillOval")) {
                g.fillOval(this.drag.x, this.drag.y, this.drag.width + 1, this.drag.height + 1);
            } else if (this.activeTool.equals("Oval")) {
                g.drawOval(this.drag.x, this.drag.y, this.drag.width, this.drag.height);
            } else if (this.activeTool.equals("FillRect")) {
                g.fillRect(this.drag.x, this.drag.y, this.drag.width + 1, this.drag.height + 1);
            } else if (this.activeTool.equals("Rect")) {
                g.drawRect(this.drag.x, this.drag.y, this.drag.width, this.drag.height);
            } else if (this.activeTool.equals("FillRoundRect")) {
                g.fillRoundRect(this.drag.x, this.drag.y, this.drag.width + 1, this.drag.height + 1, 5, 5);
            } else if (this.activeTool.equals("RoundRect")) {
                g.drawRoundRect(this.drag.x, this.drag.y, this.drag.width, this.drag.height, 4, 4);
            } else if (this.activeTool.equals("Transpose")) {
                int x = 0;
                while (x < this.drag.width) {
                    int y = 0;
                    while (y < this.drag.height) {
                        if (this.image.getRGB(this.drag.x + x, this.drag.y + y) == this.fgColor.getRGB()) {
                            this.image.setRGB(this.drag.x + x, this.drag.y + y, this.bgColor.getRGB());
                        }
                        ++y;
                    }
                    ++x;
                }
            } else if (this.activeTool.equals("Cut") || this.activeTool.equals("Copy")) {
                this.move = new BufferedImage(this.drag.width + 1, this.drag.height + 1, 2);
                Graphics2D g2 = (Graphics2D)this.move.getGraphics();
                g2.drawImage(this.image, 0, 0, this.drag.width + 1, this.drag.height + 1, this.drag.x, this.drag.y, this.drag.x + this.drag.width + 1, this.drag.y + this.drag.height + 1, this);
                ImageSelection selection = new ImageSelection(this.move, this.drag.width + 1, this.drag.height + 1);
                clipboard.setContents(selection, selection);
                if (this.activeTool.equals("Cut")) {
                    this.curColor = this.bgColor;
                    g.setColor(this.bgColor == TRANSPARENT ? TRANSPARENT_SHOW : this.bgColor);
                    g.fillRect(this.drag.x, this.drag.y, this.drag.width + 1, this.drag.height + 1);
                } else {
                    modified = false;
                }
            } else if (this.activeTool.equals("Paste")) {
                Transferable contents = clipboard.getContents(this);
                if (contents != null && contents.isDataFlavorSupported(ImageSelection.ImageFlavor)) {
                    try {
                        Image newImage = (Image)contents.getTransferData(ImageSelection.ImageFlavor);
                        g.drawImage(newImage, this.drag.x, this.drag.y, this.drag.x + this.drag.width + 1, this.drag.y + this.drag.height + 1, 0, 0, Math.min(this.image.getWidth(), this.drag.width + 1), Math.min(this.image.getHeight(), this.drag.height + 1), this);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    catch (UnsupportedFlavorException ufe) {
                        ufe.printStackTrace();
                    }
                }
            } else {
                modified = false;
            }
            if (modified) {
                this.checkForTransparency();
                this.setModified(true);
            }
        }
        this.move = null;
        this.drag = null;
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.drag != null) {
            this.drawSelection(g, this.getInsets());
        }
    }

    protected void resetNode() {
        try {
            this.imageNode.revert();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.loadImage();
    }

    protected void resizeImage(int width, int height) {
        BufferedImage buffer = new BufferedImage(width, height, 2);
        Graphics g = buffer.getGraphics();
        g.drawImage(this.image, 0, 0, null);
        this.image = buffer;
        this.repaint();
        this.setModified(true);
    }

    protected void saveNode() {
        try {
            this.imageNode.save();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Error during save:\n" + ex.getMessage(), "GIF Editor", 0);
        }
    }

    public void setAntiAliased(boolean value) {
        this.antiAliased = value;
    }

    public void setBGColor(Color color) {
        this.bgColor = color;
    }

    public void setFGColor(Color color) {
        this.fgColor = color;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.repaint();
        this.setModified(true);
    }

    public void setModified(boolean value) {
        this.modified = value;
        this.firePropertyChange(IMAGE_PROP, null, this.image);
        if (this.modified && this.imageNode != null && !this.isReadOnly()) {
            try {
                this.imageNode.getBuffer().setContent((BufferUpdater)this);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void setNode(ImageFileNode node) {
        if (this.imageNode != null) {
            try {
                this.imageNode.getBuffer().removeBufferListener((BufferListener)this);
            }
            catch (IOException ex) {
            }
        }
        this.imageNode = node;
        try {
            this.setReadOnly(this.imageNode.getBuffer().isReadOnly());
            this.imageNode.getBuffer().addBufferListener((BufferListener)this);
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.loadImage();
    }

    public void setReadOnly(boolean value) {
        this.readonly = value;
        if (this.readonly) {
            this.lastTool = this.activeTool;
            this.activeTool = "None";
            this.firePropertyChange(TOOL_PROP, this.lastTool, this.activeTool);
        }
    }

    public void setToolName(String toolName) {
        if (this.activeTool.equals(toolName)) {
            return;
        }
        this.lastTool = this.activeTool;
        this.activeTool = toolName;
        this.firePropertyChange(TOOL_PROP, this.lastTool, this.activeTool);
    }
}

