/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.gifeditor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class PixelView
extends JPanel {
    protected int cellSize;
    protected BufferedImage image;

    public PixelView(BufferedImage image, int cellSize) {
        this.image = image != null ? image : new BufferedImage(16, 16, 2);
        this.cellSize = cellSize;
    }

    protected void drawCell(Graphics g, Insets insets, int x, int y, int rgb) {
        int alpha = rgb >> 24 & 0xFF;
        int xOffset = insets.left + x * this.cellSize;
        int yOffset = insets.top + y * this.cellSize;
        if (!g.hitClip(xOffset + 1, yOffset + 1, this.cellSize - 1, this.cellSize - 1)) {
            return;
        }
        g.setColor(alpha == 0 ? this.getBackground() : new Color(rgb));
        g.fillRect(xOffset + 1, yOffset + 1, this.cellSize - 1, this.cellSize - 1);
        if (alpha == 0) {
            g.setColor(Color.black);
            g.drawLine(xOffset + this.cellSize / 2, yOffset + this.cellSize / 2, xOffset + this.cellSize / 2, yOffset + this.cellSize / 2);
        }
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        return new Dimension(insets.left + insets.right + width * this.cellSize + 1, insets.top + insets.bottom + height * this.cellSize + 1);
    }

    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        Insets insets = this.getInsets();
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        g.setColor(Color.lightGray);
        int xOffset = 0;
        int yOffset = insets.top + height * this.cellSize;
        int x = 0;
        while (x <= width) {
            xOffset = insets.left + x * this.cellSize;
            g.drawLine(xOffset, insets.top, xOffset, yOffset);
            ++x;
        }
        xOffset = insets.left + width * this.cellSize;
        int y = 0;
        while (y <= height) {
            yOffset = insets.top + y * this.cellSize;
            g.drawLine(insets.left, yOffset, xOffset, yOffset);
            ++y;
        }
        int x2 = 0;
        while (x2 < width) {
            int y2 = 0;
            while (y2 < height) {
                this.drawCell(g, insets, x2, y2, this.image.getRGB(x2, y2));
                ++y2;
            }
            ++x2;
        }
    }

    public void setCellSize(int value) {
        if (value != this.cellSize && value >= 4 && value <= 128) {
            this.cellSize = value;
            this.repaint();
        }
    }
}

