/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.gifeditor;

import com.borland.primetime.ide.Browser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ResizeDialog
extends JDialog {
    private JButton cancelButton;
    private DocumentListener docListener;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private int height = -1;
    private JTextField heightField;
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JButton okButton;
    private int width = -1;
    private JTextField widthField = new JTextField();

    public ResizeDialog(int width, int height) {
        super((Frame)Browser.getActiveBrowser(), "Resize Image", true);
        this.jLabel2 = new JLabel();
        this.heightField = new JTextField();
        this.jPanel1 = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.docListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                ResizeDialog.this.resizeFieldsChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                ResizeDialog.this.resizeFieldsChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                ResizeDialog.this.resizeFieldsChanged();
            }
        };
        try {
            this.jbInit();
            this.widthField.setText(String.valueOf(width));
            this.heightField.setText(String.valueOf(height));
            this.pack();
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this).setLocation((int)(screen.getWidth() - (double)this.getWidth()) / 2, (int)(screen.getHeight() - (double)this.getHeight()) / 2);
            this.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void button_actionPerformed(ActionEvent e) {
        this.hide();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    void heightField_focusGained(FocusEvent e) {
        this.heightField.selectAll();
    }

    public boolean isCancelled() {
        return this.width == -1;
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout);
        this.jLabel1.setMaximumSize(new Dimension(36, 17));
        this.jLabel1.setMinimumSize(new Dimension(36, 17));
        this.jLabel1.setPreferredSize(new Dimension(36, 17));
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText("Width");
        this.jLabel2.setMinimumSize(new Dimension(40, 17));
        this.jLabel2.setPreferredSize(new Dimension(40, 17));
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("Height");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResizeDialog.this.button_actionPerformed(e);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResizeDialog.this.button_actionPerformed(e);
            }
        });
        this.okButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.okButton);
        this.widthField.setMinimumSize(new Dimension(40, 21));
        this.widthField.setPreferredSize(new Dimension(40, 21));
        this.widthField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ResizeDialog.this.widthField_focusGained(e);
            }
        });
        this.widthField.getDocument().addDocumentListener(this.docListener);
        this.heightField.setMinimumSize(new Dimension(40, 21));
        this.heightField.setPreferredSize(new Dimension(40, 21));
        this.heightField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ResizeDialog.this.heightField_focusGained(e);
            }
        });
        this.heightField.getDocument().addDocumentListener(this.docListener);
        this.getContentPane().add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(2, 4, 2, 4), 0, 0));
        this.getContentPane().add((Component)this.widthField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 4, 2, 4), 0, 0));
        this.getContentPane().add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 2, 4), 0, 0));
        this.getContentPane().add((Component)this.heightField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 2, 4), 0, 0));
        this.getContentPane().add((Component)this.jPanel1, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.okButton, null);
        this.jPanel1.add((Component)this.cancelButton, null);
    }

    private void resizeFieldsChanged() {
        try {
            this.width = Integer.parseInt(this.widthField.getText());
            this.height = Integer.parseInt(this.heightField.getText());
            if (this.width < 1 || this.height < 1) {
                throw new NumberFormatException();
            }
            this.okButton.setEnabled(true);
        }
        catch (NumberFormatException ex) {
            this.width = -1;
            this.height = -1;
            this.okButton.setEnabled(false);
        }
    }

    void widthField_focusGained(FocusEvent e) {
        this.widthField.selectAll();
    }
}

