/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.gifeditor;

import com.borland.primetime.actions.StateAction;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import wood.keith.opentools.gifeditor.PixelEditor;

public class ToolAction
extends StateAction {
    private Cursor cursor = null;
    private PixelEditor editor = null;
    private String toolName = null;

    public ToolAction(PixelEditor editor, String name, Point hotspot, String tip) {
        super(tip);
        this.editor = editor;
        this.toolName = name;
        this.setSmallIcon(this.loadIcon(name, hotspot));
        this.setGrouped(true);
    }

    public boolean getState(Object source) {
        return this.editor.getToolName().equals(this.toolName);
    }

    public String getToolName() {
        return this.toolName;
    }

    private Icon loadIcon(String name, Point hotspot) {
        try {
            URL cursorUrl = ClassLoader.getSystemResource(((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/') + "/" + name + "Cursor.gif");
            this.cursor = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(cursorUrl).getImage(), hotspot, name);
        }
        catch (NullPointerException ex) {
            this.cursor = Cursor.getDefaultCursor();
        }
        URL iconUrl = ClassLoader.getSystemResource(((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/') + "/" + name + "Icon.gif");
        return new ImageIcon(iconUrl);
    }

    public void setState(Object source, boolean state) {
        if (state) {
            this.editor.setToolName(this.toolName);
            this.editor.setCursor(this.cursor);
        }
        this.update(source);
    }
}

