package wood.keith.opentools.gifeditor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

/**
 * The structure pane component for the GIF editor.
 * It shows the image at its normal size, as well as its size.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  30 August 2001
 */
public class GIFEditorStructure extends JScrollPane
		implements PropertyChangeListener {
	private JLabel imageLabel = new JLabel();
	private TitledBorder titledBorder;

	private static final int INSET = 10;

	/**
	 * Create the structure pane component.
	 * Register for changes to the image for redisplay.
	 *
	 * @param  gifEditor  the GIFEditor content pane component
	 */
	public GIFEditorStructure(GIFEditor gifEditor) {
		try {
			jbInit();
			gifEditor.addPropertyChangeListener(PixelEditor.IMAGE_PROP, this);
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}

	private void jbInit() throws Exception {
		titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(new Color(188, 255, 198),new Color(92, 128, 97)),"Preview");
		imageLabel.setHorizontalAlignment(JLabel.CENTER);
		this.setBorder(titledBorder);
		this.getViewport().add(imageLabel, null);
	}

	/**
	 * Respond to changes in the underlying image.
	 *
	 * @param  evt  the event for this property change
	 */
	public void propertyChange(PropertyChangeEvent evt) {
		if (evt.getPropertyName().equals(PixelEditor.IMAGE_PROP)) {
			BufferedImage image = (BufferedImage)evt.getNewValue();
			imageLabel.setIcon(new ImageIcon(image));
			imageLabel.setPreferredSize(new Dimension(
				image.getWidth() + INSET, image.getHeight() + INSET));
			titledBorder.setTitle("Preview (" + image.getWidth() + "x" +
				image.getHeight() + ")");
			this.repaint();
		}
	}
}