package wood.keith.opentools.gifeditor;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

import com.borland.primetime.ide.Context;
import com.borland.primetime.node.ImageFileNode;
import com.borland.primetime.viewer.AbstractNodeViewer;

/**
 * GIFEditorViewer is a wrapper around GIFEditor, which is
 * the class that implements the low level details of managing
 * a viewer, in this case an image editing tool.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  30 August 2001
 */
public class GIFEditorViewer extends AbstractNodeViewer {

  /**
   * Title, longer description, and icon for the viewer tab.
   */
  private static final String TAB_TITLE = "Design";
  private static final String TAB_DESC = "GIF Editor";
  private static final Icon TAB_ICON =
    new ImageIcon(ClassLoader.getSystemResource(
    "wood/keith/opentools/gifeditor/PencilIcon.gif"));

  /**
   * Create a GIFEditorViewer object.
   *
   * @param  context  the context (browser and node) of the editor buffer
   */
  public GIFEditorViewer(Context context) {
    super(context);
  }

  /**
   * This title will show on the tab of the viewer.
   */
  public String getViewerTitle() { return TAB_TITLE; }

  /**
   * This icon will show on the tab of the viewer.
   */
  public Icon getViewerIcon() { return TAB_ICON; }

  /**
   * This is a longer description of the viewer.
   */
  public String getViewerDescription() { return TAB_DESC; }

  /**
   * Creates the UI component to display in the content pane - the GIF editor.
   *
   * @return  the GIFEditor to display on the content pane
   */
  public JComponent createViewerComponent() {
    return new GIFEditor((ImageFileNode)getContext().getNode());
  }

  /**
   * Creates the UI component to display in the structure pane.
   *
   * @return  the structure component
   */
  public JComponent createStructureComponent() {
    return new GIFEditorStructure((GIFEditor)getViewerComponent());
  }
}
