package wood.keith.opentools.gifeditor;

import com.borland.primetime.PrimeTime;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.Context;
import com.borland.primetime.ide.NodeViewer;
import com.borland.primetime.ide.NodeViewerFactory;
import com.borland.primetime.node.ImageFileNode;
import com.borland.primetime.node.Node;

/**
 * Create a content page for editing GIF images.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.1  30 September 2001
 * @version  1.0  30 August 2001
 */
public class GIFEditorViewerFactory implements NodeViewerFactory {

  private static final String VERSION = "2.1";

  /**
   * Register this factory as a NodeViewer factory.
   *
   * @param  majorVersion  the major version of the current OpenTools API
   * @param  minorVersion  the minor version of the current OpenTools API
   */
  public static void initOpenTool(byte majorVersion, byte minorVersion) {
    if (majorVersion != PrimeTime.CURRENT_MAJOR_VERSION) {
      return;
    }
    Browser.registerNodeViewerFactory(new GIFEditorViewerFactory());
    if (PrimeTime.isVerbose()) {
      System.out.println("Loaded GIF editor v" + VERSION);
      System.out.println("Written by Keith Wood (kbwood@iprimus.com.au)");
    }
  }

  public GIFEditorViewerFactory() {
  }

  /**
   * Use this function to tell the Browser if this factory can
   * view a certain node.
   *
   * @param  node  the node the Browser will open
   * @return  true if this factory can create a viewer for this node,
   *          false otherwise
   */
  public boolean canDisplayNode(Node node) {
    return (node instanceof ImageFileNode &&
        node.getDisplayName().toLowerCase().endsWith(".gif"));
  }

  /**
   * Used to create the viewer for the node that is described
   * by a context. The viewer created is of type GIFEditorViewer.
   *
   * @param  context  the context that describes the node
   * @return  a NodeViewer capable of viewing this node,
   *          or null if the node cannot be displayed in this viewer
   */
  public NodeViewer createNodeViewer(Context context) {
    if (canDisplayNode(context.getNode())) {
      return new GIFEditorViewer(context);
    }
    return null;
  }
}
