package wood.keith.opentools.gifeditor;

import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/**
 * Actions for editor operations.
 * Each one loads an appropriate icon (based on the name)
 * but the actual action is specified elsewhere.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  30 August 2001
 */
public abstract class OperationAction extends AbstractAction {

  protected PixelEditor editor = null;

  /**
   * Create an action for this operation.
   *
   * @param  editor  the pixel editor to work with
   * @param  name    the operation name
   * @param  tip     the tool tip text for this operation
   */
  public OperationAction(PixelEditor editor, String name, String tip) {
    super(name);
    this.editor = editor;
    putValue(Action.SMALL_ICON, loadIcon(name));
    putValue(Action.SHORT_DESCRIPTION, tip);
  }

  /**
   * Load the icon for this operation.
   *
   * @param  name  the operation name (base for the image file names)
   * @return  the icon for this operation
   */
  private Icon loadIcon(String name) {
    URL iconUrl = ClassLoader.getSystemResource(
      getClass().getPackage().getName().replace('.', '/') +
      "/" + name + "Icon.gif");
    return new ImageIcon(iconUrl);
  }

  /**
   * Default operation - do nothing.
   * Expected to be overridden in a subclass.
   */
  public void actionPerformed(ActionEvent evt) {
  }
}