package wood.keith.opentools.gifeditor;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import com.borland.primetime.ide.Browser;

/**
 * Dialog to ask user for new image size.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  30 August 2001
 */
public class ResizeDialog extends JDialog {
	private GridBagLayout gridBagLayout = new GridBagLayout();
	private JLabel jLabel1 = new JLabel();
	private JTextField widthField = new JTextField();
	private JLabel jLabel2 = new JLabel();
	private JTextField heightField = new JTextField();
	private JPanel jPanel1 = new JPanel();
	private JButton cancelButton = new JButton();
	private JButton okButton = new JButton();
	private DocumentListener docListener = new DocumentListener() {
		public void insertUpdate(DocumentEvent e) {
			resizeFieldsChanged();
		}
		public void removeUpdate(DocumentEvent e) {
			resizeFieldsChanged();
		}
		public void changedUpdate(DocumentEvent e) {
			resizeFieldsChanged();
		}
	};

	private int width = -1;
	private int height = -1;

	/**
	 * Construct a new dialog, fill it with current details, and display it.
	 *
	 * @param  width   the current width of the image
	 * @param  height  the current height of the image
	 */
	public ResizeDialog(int width, int height) {
		super(Browser.getActiveBrowser(), "Resize Image", true);
		try {
			jbInit();
			widthField.setText(String.valueOf(width));
			heightField.setText(String.valueOf(height));
			pack();
			Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
			setLocation((int)(screen.getWidth() - getWidth()) / 2,
				(int)(screen.getHeight() - getHeight()) / 2);
			show();
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void jbInit() throws Exception {
		this.getContentPane().setLayout(gridBagLayout);
		jLabel1.setMaximumSize(new Dimension(36, 17));
		jLabel1.setMinimumSize(new Dimension(36, 17));
		jLabel1.setPreferredSize(new Dimension(36, 17));
		jLabel1.setHorizontalAlignment(SwingConstants.TRAILING);
		jLabel1.setText("Width");
		jLabel2.setMinimumSize(new Dimension(40, 17));
		jLabel2.setPreferredSize(new Dimension(40, 17));
		jLabel2.setHorizontalAlignment(SwingConstants.TRAILING);
		jLabel2.setText("Height");
		cancelButton.setText("Cancel");
		cancelButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				button_actionPerformed(e);
			}
		});
		okButton.setText("OK");
		okButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				button_actionPerformed(e);
			}
		});
		okButton.setDefaultCapable(true);
		this.getRootPane().setDefaultButton(okButton);
		widthField.setMinimumSize(new Dimension(40, 21));
		widthField.setPreferredSize(new Dimension(40, 21));
    widthField.addFocusListener(new java.awt.event.FocusAdapter() {
      public void focusGained(FocusEvent e) {
        widthField_focusGained(e);
      }
    });
		widthField.getDocument().addDocumentListener(docListener);
		heightField.setMinimumSize(new Dimension(40, 21));
		heightField.setPreferredSize(new Dimension(40, 21));
    heightField.addFocusListener(new java.awt.event.FocusAdapter() {
      public void focusGained(FocusEvent e) {
        heightField_focusGained(e);
      }
    });
		heightField.getDocument().addDocumentListener(docListener);
		this.getContentPane().add(jLabel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
						,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 4, 2, 4), 0, 0));
		this.getContentPane().add(widthField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
						,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 4, 2, 4), 0, 0));
		this.getContentPane().add(jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
						,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 4, 2, 4), 0, 0));
		this.getContentPane().add(heightField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
						,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 4, 2, 4), 0, 0));
		this.getContentPane().add(jPanel1, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0
						,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(okButton, null);
		jPanel1.add(cancelButton, null);
	}

	public int getWidth() { return width; }

	public int getHeight() { return height; }

	public boolean isCancelled() { return (width == -1); }

  void widthField_focusGained(FocusEvent e) {
    widthField.selectAll();
  }

  void heightField_focusGained(FocusEvent e) {
    heightField.selectAll();
  }

	/**
	 * Validate the entered width and height and enable OK button accordingly.
	 */
	private void resizeFieldsChanged() {
		try {
			width = Integer.parseInt(widthField.getText());
			height = Integer.parseInt(heightField.getText());
			if (width < 1 || height < 1) {
				throw new NumberFormatException();
			}
			okButton.setEnabled(true);
		}
		catch (NumberFormatException ex) {
			width = -1;
			height = -1;
			okButton.setEnabled(false);
		}
	}

	void button_actionPerformed(ActionEvent e) {
		hide();
	}
}