package wood.keith.opentools.gifeditor;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;

import com.borland.primetime.actions.StateAction;

/**
 * Actions for drawing tools.
 * Each one sets its tool into the editor.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  30 August 2001
 */
public class ToolAction extends StateAction {

  private PixelEditor editor = null;
  private String toolName = null;
  private Cursor cursor = null;

  /**
   * Create an action for this tool.
   *
   * @param  editor   the pixel editor to work with
   * @param  name     the tool name (base for the image file names)
   * @param  hotspot  the location of the hotspot in the cursor
   * @param  tip      the tool tip text
   */
  public ToolAction(PixelEditor editor, String name, Point hotspot,
      String tip) {
    super(tip);
    this.editor = editor;
    toolName = name;
    setSmallIcon(loadIcon(name, hotspot));
    setGrouped(true);
  }

  /**
   * Load the icon and (optional) cursor for this tool.
   *
   * @param  name     the tool name (base for the image file names)
   * @param  hotspot  the location of the hotspot in the cursor
   * @return  the icon for this tool
   */
  private Icon loadIcon(String name, Point hotspot) {
    try {
      URL cursorUrl = ClassLoader.getSystemResource(
        getClass().getPackage().getName().replace('.', '/') +
        "/" + name + "Cursor.gif");
      cursor = Toolkit.getDefaultToolkit().createCustomCursor(
        new ImageIcon(cursorUrl).getImage(), hotspot, name);
    }
    catch (NullPointerException ex) {
      cursor = Cursor.getDefaultCursor();
    }
    URL iconUrl = ClassLoader.getSystemResource(
      getClass().getPackage().getName().replace('.', '/') +
      "/" + name + "Icon.gif");
    return new ImageIcon(iconUrl);
  }

  /**
   * Is this tool the currently active one?
   */
  public boolean getState(Object source) {
    return editor.getToolName().equals(toolName);
  }

  /**
   * Apply this tool to the editor.
   */
  public void setState(Object source, boolean state) {
    if (state) {
      editor.setToolName(toolName);
      editor.setCursor(cursor);
    }
    update(source);
  }

  /**
   * Retrieve the name of this tool.
   *
   * @return  the tool's name
   */
  public String getToolName() { return toolName; }
}