/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.vfs.http;

import com.borland.primetime.help.HelpTopic;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.ui.SearchTree;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.VFS;
import com.borland.primetime.vfs.ui.UrlChooserPage;
import com.borland.primetime.vfs.ui.UrlExplorerIcons;
import com.borland.primetime.vfs.ui.UrlFilter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import wood.keith.opentools.vfs.http.HttpFilesystem;

public class HttpFSChooserPage
extends UrlChooserPage {
    public static final Icon ROOT_ICON = new ImageIcon(ClassLoader.getSystemResource("wood/keith/opentools/vfs/http/HttpFilesystemS.gif"));
    private int _mode;
    private Url _rootUrl = null;
    private GridBagLayout _gridBagLayout = new GridBagLayout();
    private JPanel _buttonPanel = new JPanel();
    private FlowLayout _flowLayout = new FlowLayout();
    private JButton _upButton = new JButton();
    private JButton _newButton = new JButton();
    private JButton _deleteButton = new JButton();
    private JScrollPane _dirScroll = new JScrollPane();
    private DefaultTreeModel _dirModel = null;
    private SearchTree _dirTree = new SearchTree();
    private JScrollPane _fileScroll = new JScrollPane();
    private DefaultListModel _fileModel = new DefaultListModel();
    private JList _fileList = new JList(this._fileModel);
    private JLabel _nameLabel = new JLabel();
    private JTextField _nameText = new JTextField();
    private JLabel _typeLabel = new JLabel();
    private JComboBox _typeCombo = new JComboBox();

    public HttpFSChooserPage(int mode) {
        this();
        this._mode = mode;
        this.initialise();
    }

    public HttpFSChooserPage() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ((Container)((Object)this)).setLayout(this._gridBagLayout);
        this._nameLabel.setDisplayedMnemonic('N');
        this._nameLabel.setLabelFor(this._nameText);
        this._nameLabel.setText("File name");
        this._nameText.setMinimumSize(new Dimension(4, 21));
        this._nameText.setPreferredSize(new Dimension(63, 21));
        this._nameText.setText("");
        this._typeLabel.setDisplayedMnemonic('T');
        this._typeLabel.setLabelFor(this._typeCombo);
        this._typeLabel.setText("File type");
        this._typeCombo.setRenderer(new UrlFilterListRenderer());
        this._typeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                HttpFSChooserPage.this._typeCombo_actionPerformed(event);
            }
        });
        this._buttonPanel.setLayout(this._flowLayout);
        this._buttonPanel.setMinimumSize(new Dimension(83, 25));
        this._buttonPanel.setPreferredSize(new Dimension(83, 25));
        this._flowLayout.setAlignment(2);
        this._upButton.setBorder(null);
        this._upButton.setMaximumSize(new Dimension(21, 21));
        this._upButton.setMinimumSize(new Dimension(21, 21));
        this._upButton.setPreferredSize(new Dimension(21, 21));
        this._upButton.setToolTipText("Move up a folder");
        this._upButton.setMargin(new Insets(0, 0, 0, 0));
        this._upButton.setText("");
        this._upButton.setIcon(UrlExplorerIcons.ICON_UP_FOLDER);
        this._upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                HttpFSChooserPage.this._upButton_actionPerformed(event);
            }
        });
        this._newButton.setBorder(null);
        this._newButton.setMaximumSize(new Dimension(21, 21));
        this._newButton.setMinimumSize(new Dimension(21, 21));
        this._newButton.setPreferredSize(new Dimension(21, 21));
        this._newButton.setToolTipText("Create a new directory");
        this._newButton.setMargin(new Insets(0, 0, 0, 0));
        this._newButton.setText("");
        this._newButton.setIcon(UrlExplorerIcons.ICON_NEW_FOLDER);
        this._newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                HttpFSChooserPage.this._newButton_actionPerformed(event);
            }
        });
        this._deleteButton.setBorder(null);
        this._deleteButton.setMaximumSize(new Dimension(21, 21));
        this._deleteButton.setMinimumSize(new Dimension(21, 21));
        this._deleteButton.setPreferredSize(new Dimension(21, 21));
        this._deleteButton.setToolTipText("Delete directory or file");
        this._deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this._deleteButton.setText("");
        this._deleteButton.setIcon(UrlExplorerIcons.ICON_DELETE);
        this._deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                HttpFSChooserPage.this._deleteButton_actionPerformed(event);
            }
        });
        this._dirTree.setShowsRootHandles(true);
        this._dirTree.setRootVisible(true);
        this._dirTree.setCellRenderer(new UrlRenderer());
        this._dirTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent event) {
                HttpFSChooserPage.this._dirTree_valueChanged(event);
            }
        });
        this._dirTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                HttpFSChooserPage.this._dirTree_mouseClicked(event);
            }
        });
        this._fileList.setCellRenderer(new UrlListRenderer());
        this._fileList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent event) {
                HttpFSChooserPage.this._fileList_valueChanged(event);
            }
        });
        this._fileList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                HttpFSChooserPage.this._fileList_mouseClicked(event);
            }
        });
        this._dirScroll.setPreferredSize(new Dimension(76, 76));
        this._fileScroll.setPreferredSize(new Dimension(76, 76));
        ((Container)((Object)this)).add(this._buttonPanel, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        ((Container)((Object)this)).add(this._dirScroll, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 4, 2, 2), 0, 0));
        ((Container)((Object)this)).add(this._fileScroll, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        ((Container)((Object)this)).add(this._nameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 2, 2), 0, 0));
        ((Container)((Object)this)).add(this._nameText, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        ((Container)((Object)this)).add(this._typeLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 2, 2), 0, 0));
        ((Container)((Object)this)).add(this._typeCombo, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this._dirScroll.getViewport().add((Component)this._dirTree, null);
        this._fileScroll.getViewport().add((Component)this._fileList, null);
        this._buttonPanel.add((Component)this._upButton, null);
        this._buttonPanel.add((Component)this._newButton, null);
        this._buttonPanel.add((Component)this._deleteButton, null);
    }

    private void initialise() {
        if (this._mode == 1) {
            this._nameLabel.setDisplayedMnemonic('D');
            this._nameLabel.setText("Directory");
            this._typeLabel.setVisible(false);
            this._typeCombo.setVisible(false);
            this._fileScroll.setVisible(false);
        }
        this._rootUrl = new Url("httpvfs", HttpFilesystem.VFS_HOST, HttpFilesystem.VFS_HOST + "/");
        UrlTreeNode rootNode = new UrlTreeNode(this._rootUrl);
        this._dirModel = new DefaultTreeModel(rootNode);
        this._dirTree.setModel(this._dirModel);
        this._dirTree.setSelectionPath(this._dirTree.getPathForRow(0));
    }

    private void _upButton_actionPerformed(ActionEvent event) {
        TreePath path = this._dirTree.getSelectionPath();
        if (path != null && path.getParentPath() != null) {
            this._dirTree.setSelectionPath(path.getParentPath());
        }
    }

    private void _newButton_actionPerformed(ActionEvent event) {
        block2: {
            String dirName = JOptionPane.showInputDialog((Component)((Object)this), "Directory name", "Remote (HTTP)", 3);
            if (dirName == null || dirName.length() <= 0) break block2;
            Url url = (Url)((UrlTreeNode)this._dirTree.getSelectionPath().getLastPathComponent()).getUserObject();
            try {
                HttpFilesystem.FILESYSTEM.createDirectory(url.getRelativeUrl(dirName));
                this.initialise();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Error during directory create\n" + ioe.getClass().getName() + "\n" + ioe.getMessage(), "Remote (HTTP)", 0);
            }
        }
    }

    private void _deleteButton_actionPerformed(ActionEvent event) {
        block4: {
            Url url = (Url)this._fileList.getSelectedValue();
            boolean isDirectory = false;
            if (url == null) {
                url = (Url)((UrlTreeNode)this._dirTree.getSelectionPath().getLastPathComponent()).getUserObject();
                isDirectory = true;
            }
            try {
                if (JOptionPane.showConfirmDialog((Component)((Object)this), "Delete " + url.getFullName() + "?", "Remote (HTTP)", 0) != 0) break block4;
                HttpFilesystem.FILESYSTEM.delete(url);
                if (isDirectory) {
                    this.initialise();
                    break block4;
                }
                this.updateFileList();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Error during deletion\n" + ioe.getClass().getName() + "\n" + ioe.getMessage(), "Remote (HTTP)", 0);
            }
        }
    }

    private void _dirTree_valueChanged(TreeSelectionEvent event) {
        if (this._mode != 1) {
            this.updateFileList();
        }
    }

    private void _dirTree_mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 2 && this._mode == 1) {
            this.okPressed();
        }
    }

    private void _fileList_valueChanged(ListSelectionEvent event) {
        Url url = (Url)this._fileList.getSelectedValue();
        this._nameText.setText(this._fileList.getSelectedIndices().length != 1 ? "" : url.getName());
    }

    private void _fileList_mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 2) {
            this.okPressed();
        }
    }

    private void _typeCombo_actionPerformed(ActionEvent event) {
        this.updateFileList();
    }

    private void updateFileList() {
        this._fileModel.removeAllElements();
        if (this._dirTree.getSelectionPath() == null) {
            return;
        }
        Url url = (Url)((UrlTreeNode)this._dirTree.getSelectionPath().getLastPathComponent()).getUserObject();
        Url[] children = HttpFilesystem.FILESYSTEM.getChildren(url, null, 2);
        UrlFilter filter = (UrlFilter)this._typeCombo.getSelectedItem();
        int index = 0;
        while (index < children.length) {
            if (filter == null || filter.accept(children[index])) {
                this._fileModel.addElement(children[index]);
            }
            ++index;
        }
    }

    public void okPressed() {
        Url dirUrl = (Url)((UrlTreeNode)this._dirTree.getSelectionPath().getLastPathComponent()).getUserObject();
        ArrayList<Url> urls = new ArrayList<Url>();
        if (this._mode == 1) {
            if (this._nameText.getText().length() > 0) {
                urls.add(dirUrl.getRelativeUrl(this._nameText.getText()));
            } else {
                urls.add(dirUrl);
            }
        } else if (this._nameText.getText().length() > 0) {
            urls.add(dirUrl.getRelativeUrl(this._nameText.getText()));
        } else {
            Object[] files = this._fileList.getSelectedValues();
            int index = 0;
            while (index < files.length) {
                urls.add((Url)files[index]);
                ++index;
            }
        }
        if (urls.size() > 0) {
            this.closeChooser(urls.toArray(new Url[urls.size()]));
        }
    }

    public void setMultiSelectionEnabled(boolean enabled) {
        this._fileList.getSelectionModel().setSelectionMode(enabled ? 2 : 0);
    }

    public void setUrl(Url url) {
        if (!url.getProtocol().equals("httpvfs")) {
            return;
        }
        Url dirUrl = url;
        if (!VFS.isDirectory((Url)url)) {
            dirUrl = url.getParent();
        }
        TreePath path = null;
        int index = 0;
        while (index < this._dirTree.getRowCount()) {
            if (((UrlTreeNode)this._dirTree.getPathForRow(index).getLastPathComponent()).getUserObject().equals(url)) {
                path = this._dirTree.getPathForRow(index);
                break;
            }
            ++index;
        }
        if (path != null) {
            this._dirTree.setSelectionPath(path);
            if (this._mode != 1 && !VFS.isDirectory((Url)url)) {
                this._fileList.setSelectedValue(url, true);
            }
        }
    }

    public void setUrlFilters(UrlFilter[] filters) {
        int index = 0;
        while (index < filters.length) {
            this._typeCombo.addItem(filters[index]);
            ++index;
        }
        this._typeCombo.setSelectedIndex(0);
    }

    public HelpTopic getHelpTopic() {
        return null;
    }

    private class UrlFilterListRenderer
    extends DefaultListCellRenderer {
        private UrlFilterListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent((JList<?>)list, ((UrlFilter)value).getDescription(), index, isSelected, cellHasFocus);
        }
    }

    private class UrlListRenderer
    extends DefaultListCellRenderer {
        private UrlListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Url url = (Url)value;
            super.getListCellRendererComponent((JList<?>)list, url.getName(), index, isSelected, cellHasFocus);
            FileNode fileNode = Browser.getActiveBrowser().getActiveProject().createFileNode(url.getFileExtension());
            this.setIcon(fileNode.getDisplayIcon());
            return this;
        }
    }

    private class UrlRenderer
    extends DefaultTreeCellRenderer {
        private UrlRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (!(value instanceof UrlTreeNode)) {
                super.getTreeCellRendererComponent(tree, "", selected, expanded, leaf, row, hasFocus);
            } else {
                Url url = (Url)((UrlTreeNode)value).getUserObject();
                super.getTreeCellRendererComponent(tree, url.getName(), selected, expanded, leaf, row, hasFocus);
                this.setIcon(url == HttpFSChooserPage.this._rootUrl ? ROOT_ICON : UrlExplorerIcons.ICON_FOLDER);
            }
            return this;
        }
    }

    private class UrlTreeNode
    extends DefaultMutableTreeNode {
        public UrlTreeNode(Url url) {
            super(url);
            this.addChildren();
        }

        public void addChildren() {
            Url[] children = HttpFilesystem.FILESYSTEM.getChildren((Url)this.getUserObject(), null, 1);
            int index = 0;
            while (index < children.length) {
                this.add(new UrlTreeNode(children[index]));
                ++index;
            }
        }

        public String toString() {
            return ((Url)this.getUserObject()).getName();
        }
    }
}

