/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.vfs.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpFSServlet
extends HttpServlet {
    public static final String BASE_DIR = "wood.keith.httpvfs.basedir";
    public static final String PARAM_ACT = "action";
    public static final String PARAM_MOD = "modified";
    public static final String PARAM_TYPE = "type";
    public static final String ACT_CHILDREN = "children";
    public static final String ACT_DELETE = "delete";
    public static final String ACT_DIRECTORY = "isDirectory";
    public static final String ACT_EXISTS = "exists";
    public static final String ACT_GET = "get";
    public static final String ACT_LASTMOD = "lastMod";
    public static final String ACT_MKDIR = "createDirectory";
    public static final String ACT_NEWMOD = "newMod";
    public static final String ACT_READONLY = "isReadOnly";
    public static final byte BACKUP_NONE = 0;
    public static final byte BACKUP_SINGLE = 1;
    public static final int TYPE_BOTH = 3;
    public static final int TYPE_FILE = 2;
    public static final int TYPE_DIRECTORY = 1;
    public static final long MODIFIED_NEVER = Long.MIN_VALUE;
    private String baseDirectory;
    List _list = new ArrayList();
    HashMap _hashMap = new HashMap();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.baseDirectory = config.getInitParameter(BASE_DIR);
        if (this.baseDirectory == null) {
            this.baseDirectory = new File(System.getProperty("user.dir")).getAbsolutePath();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = req.getParameter(PARAM_ACT);
        if (action == null || action.equals(ACT_GET)) {
            this.handleGet(req, resp);
        } else if (action.equals(ACT_CHILDREN)) {
            this.handleChildren(req, resp);
        } else if (action.equals(ACT_DELETE)) {
            this.handleDelete(req, resp);
        } else if (action.equals(ACT_DIRECTORY)) {
            this.handleIsDirectory(req, resp);
        } else if (action.equals(ACT_EXISTS)) {
            this.handleExists(req, resp);
        } else if (action.equals(ACT_LASTMOD)) {
            this.handleLastModified(req, resp);
        } else if (action.equals(ACT_MKDIR)) {
            this.handleCreateDirectory(req, resp);
        } else if (action.equals(ACT_NEWMOD)) {
            this.handleNewModified(req, resp);
        } else if (action.equals(ACT_READONLY)) {
            this.handleIsReadOnly(req, resp);
        } else {
            resp.setStatus(400);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handlePut(req, resp);
    }

    private File getFile(HttpServletRequest req) throws IOException {
        String filename = URLDecoder.decode(req.getPathInfo());
        int pos = filename.indexOf("/", 1);
        filename = pos == -1 ? "/" : filename.substring(pos);
        if (filename.indexOf("/..") != -1) {
            throw new IOException("Cannot step out of the served subdirectory");
        }
        return new File(this.baseDirectory + filename);
    }

    private void handleChildren(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int baseLen = this.baseDirectory.length();
        int type = Integer.parseInt(req.getParameter(PARAM_TYPE));
        StringBuffer buffer = new StringBuffer("");
        File[] files = this.getFile(req).listFiles();
        if (files != null) {
            int index = 0;
            while (index < files.length) {
                if (type == 3 || files[index].isDirectory() && type == 1 || !files[index].isDirectory() && type == 2) {
                    buffer.append(files[index].getAbsolutePath().substring(baseLen).replace(File.separatorChar, '/') + (files[index].isDirectory() ? "/" : "") + "\n");
                }
                ++index;
            }
        }
        this.setResponse(resp, buffer.toString());
    }

    private void handleCreateDirectory(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.setResponse(resp, String.valueOf(this.getFile(req).mkdir()));
    }

    private void handleDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.setResponse(resp, String.valueOf(this.getFile(req).delete()));
    }

    private void handleExists(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.setResponse(resp, String.valueOf(this.getFile(req).exists()));
    }

    private void handleGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        File file = this.getFile(req);
        this.copyStream(new FileInputStream(file), (OutputStream)resp.getOutputStream());
        resp.setContentLength((int)file.length());
    }

    private void handleIsDirectory(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.setResponse(resp, String.valueOf(this.getFile(req).isDirectory()));
    }

    private void handleIsReadOnly(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        File file = this.getFile(req);
        this.setResponse(resp, String.valueOf(file.exists() && !file.canWrite()));
    }

    private void handleLastModified(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        File file = this.getFile(req);
        this.setResponse(resp, String.valueOf(file.exists() ? file.lastModified() : Long.MIN_VALUE));
    }

    private void handleNewModified(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            long lastModified = Long.parseLong(req.getParameter(PARAM_MOD));
            this.setResponse(resp, String.valueOf(this.getFile(req).setLastModified(lastModified)));
        }
        catch (NumberFormatException ex) {
            this.setResponse(resp, String.valueOf(false));
        }
    }

    private void handlePut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        byte backupLevel = (byte)req.getInputStream().read();
        try {
            File file = this.getFile(req);
            if (backupLevel != 0 && file.exists()) {
                file.renameTo(new File(file.getAbsolutePath() + "~"));
            }
            FileOutputStream fos = new FileOutputStream(file);
            this.copyStream((InputStream)req.getInputStream(), fos);
            fos.close();
            this.setResponse(resp, Boolean.TRUE.toString());
        }
        catch (Exception ex) {
            this.setResponse(resp, ex.getMessage());
        }
    }

    private void setResponse(HttpServletResponse resp, String output) throws IOException {
        resp.setContentLength(output.length());
        resp.getOutputStream().print(output);
    }

    private void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int count = 0;
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
    }

    public boolean add(Object o) {
        return this._list.add(o);
    }

    public boolean addAll(Collection c) {
        return this._list.addAll(c);
    }

    public void clear() {
        this._hashMap.clear();
    }

    public boolean containsKey(Object key) {
        return this._hashMap.containsKey(key);
    }
}

