/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.vfs.http;

import com.borland.primetime.PrimeTime;
import com.borland.primetime.editor.EditorPropertyGroup;
import com.borland.primetime.util.RegularExpression;
import com.borland.primetime.vfs.AbstractFilesystem;
import com.borland.primetime.vfs.Filesystem;
import com.borland.primetime.vfs.Url;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class HttpFilesystem
extends AbstractFilesystem {
    public static final String VERSION = "1.1";
    public static final HttpFilesystem FILESYSTEM = new HttpFilesystem();
    public static final String PROTOCOL = "httpvfs";
    private static final String IS_TRUE = String.valueOf(true);
    private static final String VFS_PROTOCOL = "http://";
    static String VFS_HOST = "localhost:8080";
    private static final String VFS_ROOT = "/httpvfs/vfs/";
    private static final String VFS_PROP = "wood.keith.httpvfs.host";

    public static void initOpenTool(byte majorVersion, byte minorVersion) {
        if (majorVersion != 4) {
            return;
        }
        Url.registerFilesystem((Filesystem)FILESYSTEM);
        if (PrimeTime.isVerbose()) {
            System.out.println("Loaded HTTP File System v1.1");
            System.out.println("Written by Keith Wood (kbwood@iprimus.com.au");
        }
    }

    private HttpFilesystem() {
        VFS_HOST = System.getProperty(VFS_PROP, VFS_HOST);
    }

    private URL makeURL(Url url, String action) {
        try {
            StringBuffer buffer = new StringBuffer(VFS_PROTOCOL).append(url.getHost()).append(VFS_ROOT).append(url.getFile());
            if (action != null) {
                buffer.append("?").append("action").append("=").append(action);
            }
            return new URL(buffer.toString());
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(url.toString());
        }
    }

    private String getResponse(Url url, String action) {
        StringWriter out = new StringWriter(80);
        try {
            char[] buffer = new char[80];
            InputStream ins = this.makeURL(url, action).openStream();
            if (ins == null) {
                return "";
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(ins));
            int count = 0;
            while ((count = in.read(buffer)) != -1) {
                out.write(buffer, 0, count);
            }
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return out.toString();
    }

    public boolean createDirectory(Url url) throws IOException {
        return this.getResponse(url, "createDirectory").equals(IS_TRUE);
    }

    public void delete(Url url) throws IOException {
        this.delete(url, false);
    }

    public void delete(Url url, boolean makeBackup) throws IOException {
        if (!this.getResponse(url, "delete").equals(IS_TRUE)) {
            throw new IOException("Couldn't delete file " + url.getFile());
        }
    }

    public boolean exists(Url url) {
        return this.getResponse(url, "exists").equals(IS_TRUE);
    }

    public Url[] getChildren(Url url, RegularExpression[] patterns, int type) {
        StringTokenizer responses = new StringTokenizer(this.getResponse(url, "children&type=" + type), "\n\r");
        ArrayList<Url> urls = new ArrayList<Url>();
        while (responses.hasMoreTokens()) {
            boolean match;
            String filename = responses.nextToken();
            if (filename == null) continue;
            boolean isDirectory = filename.charAt(filename.length() - 1) == '/';
            boolean bl = match = patterns == null || isDirectory;
            if (!match) {
                int index = 0;
                while (index < patterns.length) {
                    if (patterns[index].exactMatch(filename)) {
                        match = true;
                        break;
                    }
                    ++index;
                }
            }
            if (!match) continue;
            Url child = new Url(this.getProtocol(), url.getHost(), url.getHost() + "/" + (isDirectory ? filename.substring(0, filename.length() - 1) : filename));
            child.setFilesystemObject((Object)new Boolean(isDirectory));
            urls.add(child);
        }
        return urls.toArray(new Url[urls.size()]);
    }

    public InputStream getInputStream(Url url) throws IOException {
        return this.makeURL(url, "get").openStream();
    }

    public long getLastModified(Url url) {
        try {
            return Long.parseLong(this.getResponse(url, "lastMod"));
        }
        catch (NumberFormatException ex) {
            return Long.MIN_VALUE;
        }
    }

    public OutputStream getOutputStream(Url url) throws IOException {
        return new RemoteOutputStream(url, 1);
    }

    public OutputStream getOutputStream(Url url, boolean makeBackup) throws IOException {
        return new RemoteOutputStream(url, makeBackup ? EditorPropertyGroup.BACKUP_LEVEL.getInteger() : 0);
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public boolean isDirectory(Url url) {
        if (url.getFilesystemObject() != null) {
            return (Boolean)url.getFilesystemObject();
        }
        return this.getResponse(url, "isDirectory").equals(IS_TRUE);
    }

    public boolean isReadOnly(Url url) {
        return this.getResponse(url, "isReadOnly").equals(IS_TRUE);
    }

    public boolean setLastModified(Url url, long lastModified) {
        return this.getResponse(url, "newMod&modified=" + lastModified).equals(IS_TRUE);
    }

    private class RemoteOutputStream
    extends OutputStream {
        private Url url;
        private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        public RemoteOutputStream(Url url, int backupLevel) {
            this.url = url;
            this.buffer.write(backupLevel);
        }

        public void close() throws IOException {
            super.close();
            URLConnection conn = HttpFilesystem.this.makeURL(this.url, null).openConnection();
            conn.setAllowUserInteraction(false);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            OutputStream out = conn.getOutputStream();
            out.write(this.buffer.toByteArray(), 0, this.buffer.size());
            out.close();
            InputStream in = conn.getInputStream();
            byte[] respBuffer = new byte[100];
            if (in.read(respBuffer) != IS_TRUE.length()) {
                throw new IOException("Save failed " + new String(respBuffer));
            }
        }

        public void write(int b) throws IOException {
            this.buffer.write(b);
        }
    }
}

