package wood.keith.opentools.vfs.http;

import com.borland.primetime.PrimeTime;
import com.borland.primetime.vfs.ui.UrlChooser;
import com.borland.primetime.vfs.ui.UrlChooserPage;
import com.borland.primetime.vfs.ui.UrlChooserPageFactory;

/**
 * A factory for Url chooser pages that explore the remote filesystem.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  21 March 2004
 */

public class HttpFSChooserPageFactory extends UrlChooserPageFactory {

  public static final String PAGE_NAME = "Remote (HTTP)";

  /**
   * Register a chooser page factory for the new file system.
   *
   * @param  majorVersion  the major version of the current OpenTools API
   * @param  minorVersion  the minor version of the current OpenTools API
   */
  public static void initOpenTool(byte majorVersion, byte minorVersion) {
    if (majorVersion != PrimeTime.CURRENT_MAJOR_VERSION) {
      return;
    }
    UrlChooser.registerUrlChooserPageFactory(
        new HttpFSChooserPageFactory(PAGE_NAME));
  }

  /**
   * Create a new page factory.
   *
   * @param  name  the name of the page
   */
  public HttpFSChooserPageFactory(String name) {
    super(name);
  }

  /**
   * Create a new chooser page.
   *
   * @param  mode  MODE_DIR or MODE_FILE
   * @return  the chooser page
   */
  public UrlChooserPage createUrlChooserPage(int mode) {
    return new HttpFSChooserPage(mode);
  }
}
