/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.icontips;

import com.borland.jbuilder.node.html.Adapter;
import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import java.awt.Point;
import javax.swing.tree.TreeNode;
import wood.keith.opentools.icontips.IconTipsListener;

public class IconTipsHTMLListener
extends IconTipsListener {
    public IconTipsHTMLListener(Browser browser, Node node) {
        super(browser, node);
    }

    protected String getText(TreeNode treeNode, FileNode fileNode) {
        StringBuffer tip = new StringBuffer();
        Point location = Adapter.getLocation(treeNode);
        if (location.getX() == -1.0) {
            tip.append(treeNode.toString());
        } else {
            try {
                StringBuffer buffer = new StringBuffer(new String(fileNode.getBuffer().getContent()));
                int index = buffer.length() - 1;
                while (index >= 0) {
                    if (buffer.charAt(index) == '\r') {
                        buffer.deleteCharAt(index);
                    }
                    --index;
                }
                String content = buffer.toString();
                int offset = EditorManager.getEditor((Node)fileNode).calcCaretPosition((int)location.getX(), (int)location.getY());
                int start = 0;
                while (offset - start > 0 && content.charAt(offset - start) != '<') {
                    ++start;
                }
                int end = 0;
                while (offset + end < content.length() && content.charAt(offset + end) != '>') {
                    ++end;
                }
                tip.append(this.normalise(content.substring(offset - start, offset + end + 1).trim()));
            }
            catch (Exception ex) {
                tip.append(treeNode.toString());
            }
        }
        return tip.toString();
    }
}

