/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.icontips;

import com.borland.jbuilder.node.idl.Adapter;
import com.borland.jbuilder.node.idl.IDLStructureElement;
import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.ui.MergeTreeNode;
import java.awt.Point;
import javax.swing.tree.TreeNode;
import wood.keith.opentools.icontips.IconTipsListener;

public class IconTipsIDLListener
extends IconTipsListener {
    private static final int MEMBER_TYPE_LOW = 15;
    private static final int MEMBER_TYPE_HIGH = 17;

    public IconTipsIDLListener(Browser browser, Node node) {
        super(browser, node);
    }

    protected String getText(TreeNode treeNode, FileNode fileNode) {
        StringBuffer tip;
        block6: {
            tip = new StringBuffer();
            IDLStructureElement element = (IDLStructureElement)((MergeTreeNode)treeNode).getUserObject();
            this.addType(element.type, tip);
            try {
                Point location = Adapter.getLocation(treeNode);
                StringBuffer buffer = new StringBuffer(new String(fileNode.getBuffer().getContent()));
                int index = buffer.length() - 1;
                while (index >= 0) {
                    if (buffer.charAt(index) == '\r') {
                        buffer.deleteCharAt(index);
                    }
                    --index;
                }
                String content = buffer.toString();
                int offset = EditorManager.getEditor((Node)fileNode).calcCaretPosition((int)location.getX(), (int)location.getY());
                if (offset > -1) {
                    int end = 0;
                    while (offset + end < content.length() && content.charAt(offset + end) != '{' && content.charAt(offset + end) != '}' && content.charAt(offset + end) != ';' && (element.type < 15 || element.type > 17 || content.charAt(offset + end) != ',')) {
                        ++end;
                    }
                    tip.append(this.normalise(content.substring(offset, offset + end).trim()));
                    break block6;
                }
                tip.append(element.name);
            }
            catch (Exception ex) {
                tip.append(element.name);
            }
        }
        return tip.toString();
    }

    private void addType(int type, StringBuffer tip) {
        switch (type) {
            case 0: {
                tip.append(" [errors] ");
                break;
            }
            case 1: {
                tip.append(" [error] ");
                break;
            }
            case 18: 
            case 19: {
                tip.append(" [include] ");
                break;
            }
            case 3: {
                tip.append(" [module] ");
                break;
            }
            case 4: {
                tip.append(" [interface] ");
                break;
            }
            case 5: {
                tip.append(" [value] ");
                break;
            }
            case 6: {
                tip.append(" [alias] ");
                break;
            }
            case 7: {
                tip.append(" [const] ");
                break;
            }
            case 8: {
                tip.append(" [struct] ");
                break;
            }
            case 9: {
                tip.append(" [exception] ");
                break;
            }
            case 10: {
                tip.append(" [enum] ");
                break;
            }
            case 11: {
                tip.append(" [union] ");
                break;
            }
            case 12: {
                tip.append(" [attribute] ");
                break;
            }
            case 13: {
                tip.append(" [operation] ");
                break;
            }
            case 14: {
                tip.append(" [initializer] ");
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                tip.append(" [member] ");
                break;
            }
            case 20: {
                tip.append(" [parent interface] ");
                break;
            }
            case 21: {
                tip.append(" [parent value] ");
                break;
            }
            case 22: {
                tip.append(" [parent structure] ");
                break;
            }
            case 23: {
                tip.append(" [support value] ");
                break;
            }
            default: {
                tip.append(" [unknown] ");
            }
        }
    }
}

