/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.icontips;

import com.borland.jbuilder.node.ClassFileNode;
import com.borland.jbuilder.node.JavaFileNode;
import com.borland.jbuilder.node.java.JavaStructureElement;
import com.borland.jbuilder.node.java.JavaStructureNode;
import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import java.io.IOException;
import javax.swing.tree.TreeNode;
import wood.keith.opentools.icontips.IconTipsListener;

public class IconTipsJavaListener
extends IconTipsListener {
    public IconTipsJavaListener(Browser browser, Node node) {
        super(browser, node);
    }

    protected String getText(TreeNode treeNode, FileNode fileNode) {
        Object element;
        StringBuffer tip = new StringBuffer();
        if (treeNode instanceof JavaStructureNode && (element = ((JavaStructureNode)treeNode).getUserObject()) instanceof JavaStructureElement) {
            JavaStructureElement jelement = (JavaStructureElement)element;
            switch (jelement.type) {
                case 6: {
                    this.addVisibility(jelement, "class", tip);
                    break;
                }
                case 10: {
                    this.addVisibility(jelement, "constructor", tip);
                    break;
                }
                case 8: {
                    this.addVisibility(jelement, "field", tip);
                    break;
                }
                case 12: {
                    tip.append(" [interface] implements ").append(jelement.name);
                    break;
                }
                case 5: {
                    tip.append(" [class] import ").append(jelement.name);
                    break;
                }
                case 11: {
                    tip.append(" [class] extends ").append(jelement.name);
                    break;
                }
                case 7: {
                    this.addVisibility(jelement, "interface", tip);
                    break;
                }
                case 9: {
                    this.addVisibility(jelement, "method", tip);
                    break;
                }
                case 4: {
                    tip.append(" [class] package ").append(jelement.name);
                }
            }
            if (tip.length() > 0) {
                tip.delete(0, 1);
            }
        }
        return tip.toString();
    }

    private void addVisibility(JavaStructureElement jelement, String type, StringBuffer tip) {
        block9: {
            tip.append(" [").append(type).append("]");
            try {
                Node node = Browser.getActiveBrowser().getActiveNode();
                if (node instanceof JavaFileNode || node instanceof ClassFileNode) {
                    StringBuffer buffer = new StringBuffer(new String(node instanceof JavaFileNode ? ((JavaFileNode)node).getBuffer().getContent() : ((ClassFileNode)node).getStubSource().getBytes()));
                    int index = buffer.length() - 1;
                    while (index >= 0) {
                        if (buffer.charAt(index) == '\r') {
                            buffer.deleteCharAt(index);
                        }
                        --index;
                    }
                    String content = buffer.toString();
                    int offset = jelement.offset != -1 ? jelement.offset : EditorManager.getEditor((Node)node).calcCaretPosition(jelement.line, jelement.column);
                    int end = 0;
                    while (offset + end < content.length() && content.charAt(offset + end) != '{' && content.charAt(offset + end) != ';') {
                        ++end;
                    }
                    if (end == 0) {
                        tip.append(" static initializer");
                    } else {
                        tip.append(" ").append(this.normalise(content.substring(offset, offset + end).trim()));
                    }
                    break block9;
                }
                throw new IOException();
            }
            catch (IOException ex) {
                this.addDefaultVisibility(jelement, tip);
            }
            catch (StringIndexOutOfBoundsException ex) {
                this.addDefaultVisibility(jelement, tip);
            }
        }
    }

    private void addDefaultVisibility(JavaStructureElement jelement, StringBuffer tip) {
        int visibility = jelement.subType & 3;
        switch (visibility) {
            case 0: {
                tip.append(" private");
                break;
            }
            case 2: {
                tip.append(" protected");
                break;
            }
            case 3: {
                tip.append(" public");
                break;
            }
            case 1: {
                tip.append(" package");
            }
        }
        if ((jelement.subType & 4) == 4) {
            tip.append(" static");
        }
        tip.append(" ").append(jelement.name);
    }
}

