/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.icontips;

import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.NodeViewer;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.util.VetoException;
import com.borland.primetime.viewer.Res;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class IconTipsListener
extends MouseMotionAdapter {
    private static final String SOURCE_TAB = Res.getString((int)49);
    protected Browser _browser;
    protected FileNode _node;
    protected JTree _tree;

    public IconTipsListener(Browser browser, Node node) {
        this._browser = browser;
        this._node = (FileNode)node;
        try {
            this._tree = this.getStructureTree(browser, node);
            this._tree.addMouseMotionListener(this);
        }
        catch (VetoException ex) {
            this._tree = null;
        }
    }

    public void detach() {
        if (this._tree != null) {
            this._tree.removeMouseMotionListener(this);
        }
    }

    public void mouseMoved(MouseEvent e) {
        String tip = null;
        TreePath path = this._tree.getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            TreeNode treeNode = (TreeNode)path.getLastPathComponent();
            tip = this.getText(treeNode, this._node);
        }
        this._browser.getStatusView().setHintText(tip);
        this._tree.setToolTipText(tip);
    }

    protected abstract String getText(TreeNode var1, FileNode var2);

    protected String normalise(String value) {
        StringBuffer buffer = new StringBuffer(value);
        int index = buffer.length() - 1;
        while (index > 1) {
            if (Character.isWhitespace(buffer.charAt(index)) && Character.isWhitespace(buffer.charAt(index - 1))) {
                buffer.replace(index - 1, index + 1, " ");
            }
            --index;
        }
        return buffer.toString();
    }

    protected JTree getStructureTree(Browser browser, Node node) throws VetoException {
        NodeViewer[] viewers = browser.getViewers(node);
        int index = 0;
        while (index < viewers.length) {
            if (viewers[index].getViewerTitle().equals(SOURCE_TAB)) {
                JComponent comp = viewers[index].getStructureComponent();
                return (JTree)((JScrollPane)comp.getComponent(0)).getViewport().getComponent(0);
            }
            ++index;
        }
        throw new VetoException("Missing " + SOURCE_TAB + " tab for " + node.getDisplayName());
    }
}

