package com.borland.jbuilder.node.html;

import java.awt.Point;
import javax.swing.tree.TreeNode;

/**
 * Hack to expose HTML structure node positions within the text.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.2  3 December 2003
 */
public class Adapter {

  private static final Point NO_LOCATION = new Point(-1, -1);

  private Adapter() {
  }

  /**
   * Retrieve the positional information from the HTML structure node.
   *
   * @param  node  the HTML structure node
   * @return  its location within the text as a Point
   */
  public static Point getLocation(TreeNode node) {
    switch (((HTMLStructure.HTMLStructureNode)node).getType()) {
      case HTMLStructure.HTMLStructureNode.ATTRIBUTE:
      case HTMLStructure.HTMLStructureNode.COMMENT:
      case HTMLStructure.HTMLStructureNode.ELEMENT: break;
      default: return NO_LOCATION;
    }
    HTMLStructure.HTMLStructureNodeUserObject hobject =
        (HTMLStructure.HTMLStructureNodeUserObject)
        ((HTMLStructure.HTMLStructureNode)node).getUserObject();
    return new Point(hobject.lineNo, hobject.column);
  }
}
