package com.borland.jbuilder.node.idl;

import java.awt.Point;
import javax.swing.tree.TreeNode;

import com.borland.primetime.ui.MergeTreeNode;

/**
 * Hack to expose IDL structure node positions within the text.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.2  3 December 2003
 */
public class Adapter {

  private Adapter() {
  }

  /**
   * Retrieve the positional information from the IDL structure node.
   *
   * @param  node  the IDL structure node
   * @return  its location within the text as a Point
   */
  public static Point getLocation(TreeNode node) {
    IDLStructureElement iobject =
        (IDLStructureElement)((MergeTreeNode)node).getUserObject();
    return new Point(iobject.line, iobject.column);
  }
}
