package com.borland.jbuilder.node.xml;

import java.awt.Point;
import javax.swing.tree.TreeNode;

/**
 * Hack to expose XML structure node positions within the text.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.2  3 December 2003
 */
public class Adapter {

  private Adapter() {
  }

  /**
   * Retrieve the positional information from the XML structure node.
   *
   * @param  node  the XML structure node
   * @return  its location within the text as a Point
   */
  public static Point getLocation(TreeNode node) {
    XMLStructure.XMLStructureNodeUserObject xobject =
        (XMLStructure.XMLStructureNodeUserObject)
        ((XMLStructure.XMLStructureNode)node).getUserObject();
    return new Point(xobject.lineNo, xobject.column);
  }
}
