package wood.keith.opentools.icontips;

import com.borland.jbuilder.node.ClassFileNode;
import com.borland.jbuilder.node.HTMLFileNode;
import com.borland.jbuilder.node.IDLFileNode;
import com.borland.jbuilder.node.JavaFileNode;
import com.borland.jbuilder.node.XMLFileNode;
import com.borland.primetime.PrimeTime;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.BrowserAdapter;
import com.borland.primetime.node.Node;

/**
 * A listener for browser events - specifically node activations.
 * When a Java or XML is activated, attach a listener to its structure view.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  1 December 2000
 * @version  1.1  7 May 2001
 * @version  1.2  3 December 2003
 */
public class IconTipsActivator extends BrowserAdapter {

  private static final String VERSION = "1.2";

  // The tree view listener
  private IconTipsListener _iconTips = null;

  /**
   * Register the IconTipsActivator with JBuilder.
   * Provides the needed OpenTools interface required to register the
   * listener that creates the icon tip display.
   *
   * @param  majorVersion  the major version of the current OpenTools API
   * @param  minorVersion  the minor version of the current OpenTools API
   */
  public static void initOpenTool(byte majorVersion, byte minorVersion) {
    if (majorVersion != PrimeTime.CURRENT_MAJOR_VERSION) {
      return;
    }
    Browser.addStaticBrowserListener(new IconTipsActivator());
    if (PrimeTime.isVerbose()) {
      System.out.println("Loaded Icon Tips extension v" + VERSION);
      System.out.println("Written by Keith Wood (kbwood@iprimus.com.au)");
    }
  }

  /**
   * Attach a tree view listener to any JavaFileNode activated.
   *
   * @param  browser  the current browser
   * @param  node     the node being activated
   */
  public void browserNodeActivated(Browser browser, Node node) {
    // Tidy up and release any previous instance
    if (_iconTips != null) {
      _iconTips.detach();
    }
    _iconTips = null;

    if (node instanceof JavaFileNode || node instanceof ClassFileNode) {
      _iconTips = new IconTipsJavaListener(browser, node);
    }
    else if (node instanceof XMLFileNode) {
      _iconTips = new IconTipsXMLListener(browser, node);
    }
    else if (node instanceof HTMLFileNode) {
      _iconTips = new IconTipsHTMLListener(browser, node);
    }
    else if (node instanceof IDLFileNode) {
      _iconTips = new IconTipsIDLListener(browser, node);
    }
  }
}