package wood.keith.opentools.icontips;

import java.awt.Point;
import javax.swing.tree.TreeNode;

import com.borland.jbuilder.node.xml.Adapter;
import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;

/**
 * Listener for mouse movements over the structure view tree component.
 * Intended for XML views only, it displays the entire node in the status bar.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.2  3 December 2003
 */
public class IconTipsXMLListener extends IconTipsListener {

  /**
   * Attach this listener to the tree in the structure view.
   *
   * @param  browser  the current browser
   * @param  node     the current node
   */
  public IconTipsXMLListener(Browser browser, Node node) {
    super(browser, node);
  }

  /**
   * Retrieve the tool tip text for this node in the tree.
   *
   * @param  treeNode  the current node in the structure tree
   * @param  fileNode  the current file node
   * @return  the tool tip text for this tree node
   */
  protected String getText(TreeNode treeNode, FileNode fileNode) {
    StringBuffer tip = new StringBuffer();
    // Find its location within the file
    Point location = Adapter.getLocation(treeNode);
    if (location.getX() == -1) {
      tip.append(treeNode.toString());
    }
    else {
      try {
        // Load the content
        StringBuffer buffer =
            new StringBuffer(new String(fileNode.getBuffer().getContent()));
        for (int index = buffer.length() - 1; index >= 0; index--) {
          // Remove extraneous carriage returns
          if (buffer.charAt(index) == '\r') {
            buffer.deleteCharAt(index);
          }
        }
        String content = buffer.toString();
        // And extract the node's text (offset points to end)
        int offset = EditorManager.getEditor(fileNode).
            calcCaretPosition((int)location.getX(), (int)location.getY());
        // Offset may point to start of next element
        int start = (content.charAt(offset) == '<' ? 1 : 0);
        while (offset - start > 0 && content.charAt(offset - start) != '<') {
          start++;
        }
        tip.append(normalise(
            content.substring(offset - start, offset).trim()));
      }
      catch (Exception ex) {
        tip.append(treeNode.toString());
      }
    }
    return tip.toString();
  }
}
