/*
 * Voyager JBoss OpenTool for JBuilder
 *
 * Copyright (c) 2002 Marcus Redeker, Gedoplan GmbH - Bielefeld, Germany
 *    marcus.redeker@gedoplan.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Cyrille Morvan's excellent 'Kelly JOnAS OpenTool' sources provided
 * much of the inspiration and some of the code for this OpenTool.
 *
*/
package de.gedoplan.opentools.jboss;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.URL;


/**
 * This class creates the about box which is displayed when pressing the about
 * button on the enterprise setup property page for JBoss.
 *
 * @author <a href="mailto:marcus.redeker@gedoplan.de">Marcus Redeker (Gedoplan GmbH, Germany)</a>
 * @version 1.2
 */
public class AboutBox extends JDialog
{
  JPanel panel = new JPanel();
  private AboutBox myself;

  public AboutBox(Frame frame)
  {
    super(frame, JBossResource.get("ABOUT_BOX") + JBossResource.VOYAGER_VERSION, true);
    myself = this;
    try
    {
      setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
      URL url = getClass().getResource("/de/gedoplan/opentools/jboss/images/voyager.gif");
      ImageIcon icon = new ImageIcon(url);
      JLabel picture = new JLabel(icon);
      panel.add(picture);
      getContentPane().add(panel);
      pack();

      Dimension WindowSize=getSize(),ScreenSize=Toolkit.getDefaultToolkit().getScreenSize();
      setBounds((ScreenSize.width-WindowSize.width)/2,(ScreenSize.height-WindowSize.height)/2,WindowSize.width,WindowSize.height);

      panel.addMouseListener(new MouseAdapter()
      {
        public void mouseClicked(MouseEvent e)
        {
          myself.dispose();
        }
      });
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }
}