/*
 * Voyager JBoss OpenTool for JBuilder
 *
 * Copyright (c) 2002 Marcus Redeker, Gedoplan GmbH - Bielefeld, Germany
 *    marcus.redeker@gedoplan.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Cyrille Morvan's excellent 'Kelly JOnAS OpenTool' sources provided
 * much of the inspiration and some of the code for this OpenTool.
 *
*/
package de.gedoplan.opentools.jboss;

import com.borland.jbuilder.enterprise.ejb.*;
import java.util.ArrayList;
import com.borland.primetime.node.Project;
import java.util.Map;
import com.borland.primetime.vfs.Url;
import com.borland.jbuilder.runtime.RunJavaProcessTracker;
import java.awt.Component;
import com.borland.primetime.properties.MultipleNodeProperty;
import com.borland.primetime.properties.GlobalBooleanProperty;
import java.io.File;
import com.borland.primetime.PrimeTime;
import com.borland.jbuilder.info.JBuilderInfo;
import com.borland.jbuilder.ide.SetupManager;
import com.borland.jbuilder.wizard.ejbclient.EjbTestClientState;
import com.borland.jbuilder.jot.*;
import java.util.List;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.vfs.VFS;
import com.borland.jbuilder.node.JBProject;
import com.borland.primetime.runtime.RunConfiguration;
import com.borland.primetime.vfs.ui.UrlChooser;
import com.borland.jbuilder.enterprise.ejb.CommandLineEjbDeployer;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.MessageCategory;
import com.borland.primetime.ide.Message;
import java.io.FilenameFilter;
import com.borland.jbuilder.enterprise.ear.EarGrpUtils;
import com.borland.jbuilder.node.EarGrpFileNode;
import com.borland.jbuilder.node.JarFileNode;
import java.net.URL;
import java.net.URLConnection;

/**
 * This is the main class of the JBoss OpenTool. It extends JBuilder's abstract
 * AppServer class which is responsible for providing all needed information
 * like classpath, main class, JVM properties, ...
 *
 * @author <a href="mailto:marcus.redeker@gedoplan.de">Marcus Redeker (Gedoplan GmbH, Germany)</a>
 * @version 1.2
 */
public class JBossAppServer30 extends JBossAppServer24
{
  final static String JBOSS_DEFAULT_NAME    = JBossResource.get("SERVER_NAME");
  final static String JBOSS_DEFAULT_VERSION30 = JBossResource.get("SERVER_VERSION30");

  public JBossAppServer30()
  {
  }


  public static void initOpenTool(byte major, byte minor)
  {
    // Check OpenTools version number
    if (major != PrimeTime.CURRENT_MAJOR_VERSION)
    {
      return;
    }

    String aCompleteName = JBossResource.COMMERCIAL_NAME + " JBoss OpenTool " + JBossResource.VOYAGER_VERSION;
    if(JBuilderInfo.isEntEnabled())
    {
      JBossAppServer30 temp = new JBossAppServer30();
      AppServerManager.registerAppServer(temp);

      if ( (new Byte(minor)).intValue() < 3)   //this is not JBuilder 6 or higher
      {
        temp.isJB6 = false;
      }

      if( PrimeTime.isVerbose() )
      {
        System.out.println("#####################################################################");
        System.out.println("# " + aCompleteName + " for JBuilder 6 - Major: " + major + " - Minor: " + minor);
        System.out.println("# @author Marcus Redeker <mr@gedoplan.de>");
        System.out.println("# @see " + JBossResource.get("URL"));
        if( temp.isSetup())
        {
          System.out.println("# @home " + JBossPropertyGroup.INSTALL_PATH_30.getValue() );
        }
        else
        {
          System.out.println("# Not setup");
        }
        System.out.println("#####################################################################");
      }
    }
    else
    {
      System.out.println("ERROR : you should have JBuilder Enterprise to run " + aCompleteName );
    }
  }


  public boolean isSetup()
  {
    boolean flag = true;
    String s = JBossPropertyGroup.INSTALL_PATH_30.getValue();
    if(s == null || s.equals(""))
    {
      flag = false;
    }
    if(flag)
    {
      String s1 = JBossPropertyGroup.CONFIGURATION_NAME_30.getValue();
      if(s1 == null || s1.equals(""))
      {
        flag = false;
      }
    }
    return flag;
  }


  public String getDefaultVmParameters()
  {
    StringBuffer stringbuffer = new StringBuffer();
    stringbuffer.append("-ms64m -mx64m ");
    stringbuffer.append("-Dprogram.name=run.bat");
    return stringbuffer.toString();
  }

  /**
   * This is the name which was in my JBoss RC3 download
   * @return an URL
   */
  public Url getDefaultHomeDirectory()
  {
    return new Url("file","/jboss-3.0.0RC3/");
  }

  public String getDefaultParameters()
  {
    return "-c default";
  }

  public String getDefaultVersion()
  {
    return JBOSS_DEFAULT_VERSION30;
  }

  public String getShortName()
  {
    return AppServer.makeFullName(JBOSS_DEFAULT_NAME, JBOSS_DEFAULT_VERSION30);
  }


  public Url[] getDefaultClassPath()
  {
    Url aurl[] = new Url[2];
    String s = getDefaultHomeDirectory().getFile();
    if(!s.endsWith("/"))
        s = s + "/";

    String fileSeperator = System.getProperty("file.separator");
    String javaHome = System.getProperty("java.home");
    String toolsHome = javaHome.substring(0,javaHome.lastIndexOf(fileSeperator));

    aurl[0] = new Url("zip", ((new StringBuffer("[")).append(s).append("bin/run.jar]")).toString());
    aurl[1] = new Url("zip", ((new StringBuffer("[")).append(toolsHome).append("/lib/tools.jar]")).toString());

    return aurl;
  }


  public void updateSetup(Component parm1)
  {
    JBossSetup30 jbossSetup = (JBossSetup30)SetupManager.getSetup(getShortName(), AppServerSetup.APPSERVER_SETUP_NAME);
    if(jbossSetup != null)
    {
      jbossSetup.saveSettings(getHomeDirectory().getFile());
    }
  }


  /**
   * Check whether we have a /bin/run.jar in the specified jboss directory.
   * @param path
   * @return a string with the error message or null if everything is ok
   */
  public String isValidSetupDirectory(String path)
  {
    String s1 = null;
    JBossSetup30 jbossSetup = (JBossSetup30)SetupManager.getSetup(getShortName(), AppServerSetup.APPSERVER_SETUP_NAME);
    if(jbossSetup != null)
    {
      s1 = jbossSetup.validateInstallDirectory(path);
    }
    return s1;
  }



  /**
   * I just use this as an entry point to get the event when a user selected the deploy options with
   * a right-click on a deployable node (-jar, -war, -ear). I then trigger my own deployment mechanismn
   * since JBoss does not have a java tool like Weblogic to deploy, undeploy and list applications. I will
   * just copy the files to the JBoss deploy folder, list the folder contents or delete files out of that
   * folder.
   */
  public RunConfiguration getDeployRunConfiguration(ArrayList nodesToDeploy, int deployOptions, JBProject jbproject)
  {
    JBossEJBDeployer30 jbossDeployer = (JBossEJBDeployer30)getEjbDeployer();
    if(jbossDeployer == null)
    {
      return null;
    }

    switch (deployOptions)
    {
      case 1: jbossDeployer.deploy(nodesToDeploy, jbproject);
        break;
      case 2: jbossDeployer.redeploy(nodesToDeploy, jbproject);
        break;
      case 4: jbossDeployer.undeploy(nodesToDeploy, jbproject);
        break;
      case 8: jbossDeployer.listDeployments(nodesToDeploy, jbproject);
        break;
    }

    return null;
  }


  private void copyJarsToDeployLocation(ArrayList arraylist)
  {
    String homeDir = getHomeDirectory().getFile();
    String conf = JBossPropertyGroup.CONFIGURATION_NAME_30.getValue();
    if(!homeDir.endsWith("/"))
    {
      homeDir = homeDir + "/";
    }
    if(!conf.endsWith("/"))
    {
      conf = conf + "/";
    }
    String deployDir = homeDir + "server/" + conf + "deploy/";
    for(int i = 0; i < arraylist.size(); i++)
    {
      Url url = new Url("file", (String)arraylist.get(i));
      Url url1 = new Url("file", deployDir + url.getName());
      try
      {
        VFS.copy(url, url1);
      }
      catch(Exception exception)
      {
        exception.printStackTrace();
      }
    }
  }



}