/*
 * Voyager JBoss OpenTool for JBuilder
 *
 * Copyright (c) 2002 Marcus Redeker, Gedoplan GmbH - Bielefeld, Germany
 *    marcus.redeker@gedoplan.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Cyrille Morvan's excellent 'Kelly JOnAS OpenTool' sources provided
 * much of the inspiration and some of the code for this OpenTool.
 *
*/
package de.gedoplan.opentools.jboss;

import com.borland.jbuilder.build.*;
import com.borland.jbuilder.enterprise.ejb.*;
import com.borland.jbuilder.node.*;
import com.borland.primetime.ide.*;
import java.util.*;
import java.io.ByteArrayOutputStream;
import com.borland.enterprise.xml.api.IEjbJar;
import com.borland.enterprise.xml.api.IEnterpriseBean;
import com.borland.enterprise.xml.api.IAccessibleBean;
import com.borland.enterprise.xml.api.ISessionBean;
import com.borland.enterprise.xml.api.IEntityBean;
import com.borland.enterprise.xml.api.IMessageDrivenBean;
import com.borland.enterprise.xml.api.IEjbRef;
import com.borland.enterprise.xml.api.IProperty;
import com.borland.enterprise.xml.api.enum.EnumPersistenceType;
import com.borland.enterprise.xml.api.IResourceRef;
import com.borland.enterprise.xml.api.IResourceEnvRef;
import java.text.DateFormat;
import com.borland.primetime.util.AssertionException;
import com.borland.primetime.util.Strings;
import com.borland.enterprise.xml.api.ICmpField;
import com.borland.enterprise.xml.api.ICmpFieldMap;
import com.borland.enterprise.xml.api.IFinder;
import com.borland.enterprise.xml.api.enum.*;
import com.borland.enterprise.xml.toolkit.impl.ejb.v2_0.EjbRelation;
import com.borland.enterprise.xml.toolkit.impl.ejb.v2_0.EjbRelationshipRole;
import com.borland.enterprise.xml.toolkit.impl.ejb.v2_0.CrossTable;
import com.borland.enterprise.xml.toolkit.impl.ejb.v2_0.ColumnName;
import com.borland.enterprise.xml.toolkit.impl.ejb.v2_0.ColumnList;
import com.borland.enterprise.xml.toolkit.impl.ejb.v2_0.Property;
import java.io.*;
import java.awt.*;

/**
 * This class is used by the targeting class to create the JBoss deployment
 * descriptos. Right now it is able to create the jboss.xml and the jaws.xml.
 * Some extra properties for CMP entity beans are displayed in the DD wizard
 * on the JBoss properties tab.
 *
 * @author <a href="mailto:marcus.redeker@gedoplan.de">Marcus Redeker (Gedoplan GmbH, Germany)</a>
 * @author <a href="mailto:m0nstermind@users.sourceforge.net">Oleg Anasatsyev</a>
 * @author <a href="mailto:fred.sauer@allen-sauer.com">Frederik Sauer</a>
 * @version 2.0
 */
public class JBossDescriptorConversion30 extends JBossDescriptorConversion24
{

  protected static String[] cmpProperties30 = new String[]{"datasource", "create-table", "remove-table", "read-only",
                                                  "time-out", "datasource-mapping", "pk-constraint", "fk-constraint",
                                                  "row-locking","preferred-relation-mapping", "list-cache-max"
                                                  };

  public JBossDescriptorConversion30(DeploymentDescriptor adeploymentdescriptor[], EJBGRPFileNode ejbgrpfilenode, BuildReport buildreport)
  {
    super(adeploymentdescriptor, ejbgrpfilenode, buildreport);
  }

  protected void generateJbossCmpDeploymentDescriptor(ArrayList cmpEntityBeans, ArrayList ddList, String datasource, String typeMapping, String datasourceMapping, MessageView msgview) throws Exception
	{
		XMLNode rootNode = new XMLNode(null, "jbosscmp-jdbc");

		//defaults
		XMLNode defaultsNode = new XMLNode(rootNode, "defaults");
		new XMLNode(defaultsNode, "datasource", datasource);
		new XMLNode(defaultsNode, "datasource-mapping", datasourceMapping);

		//enterprise beans
		XMLNode enterpriseBeansNode = new XMLNode(rootNode, "enterprise-beans");
		XMLNode beanNode = null;
		for (Iterator i = cmpEntityBeans.iterator(); i.hasNext(); )
		{
			IEntityBean entityBean = (IEntityBean)i.next();
			Map props = new HashMap();
			for (Iterator l = entityBean.getPropertyList().iterator(); l.hasNext(); )
			{
				IProperty item = (IProperty)l.next();
				props.put(item.getPropName(), item.getPropValue());
			}

			beanNode = new XMLNode(enterpriseBeansNode, "entity");
			new XMLNode(beanNode, "ejb-name", entityBean.getEjbName());

			// Note: table related tags must appear in the XML source before table-name tag or JBoss complains
			if (props.containsKey("datasource"))
				new XMLNode(beanNode, "datasource", (String)props.get("datasource"));

			if (props.containsKey("datasource-mapping"))
				new XMLNode(beanNode, "datasource-mapping", (String)props.get("datasource-mapping"));

			if (props.containsKey("create-table"))
				new XMLNode(beanNode, "create-table", (String)props.get("create-table"));

			if (props.containsKey("remove-table"))
				new XMLNode(beanNode, "remove-table", (String)props.get("remove-table"));

			if (props.containsKey("pk-constraint"))
				new XMLNode(beanNode, "pk-constraint", (String)props.get("pk-constraint"));

			if (props.containsKey("fk-constraint"))
				new XMLNode(beanNode, "fk-constraint", (String)props.get("fk-constraint"));

			if (props.containsKey("row-locking"))
				new XMLNode(beanNode, "row-locking", (String)props.get("row-locking"));

			if (props.containsKey("preferred-relation-mapping"))
				new XMLNode(beanNode, "preferred-relation-mapping", (String)props.get("preferred-relation-mapping"));

			// Note: table-name must appear in the XML source before any cmp-field tags or JBoss complains
			new XMLNode(beanNode, "table-name", stripQuotes(entityBean.getTableName()));

			Collection cmpFieldList = entityBean.getCmpFieldList();
			if (cmpFieldList != null)
			{
				XMLNode cmpFieldNode = null;
				for (Iterator j = cmpFieldList.iterator(); j.hasNext(); )
				{
					ICmpField cmpField = (ICmpField)j.next();
					cmpFieldNode = new XMLNode(beanNode, "cmp-field");
					new XMLNode(cmpFieldNode, "field-name", cmpField.getFieldName());
					new XMLNode(cmpFieldNode, "column-name", stripQuotes(cmpField.getColumnName()));
				}
			}

			Collection finderList = entityBean.getFinderList();
			if (finderList != null)
			{
				XMLNode finderNode = null;
				for (Iterator k = finderList.iterator(); k.hasNext(); )
				{
					IFinder finder = (IFinder)k.next();
					if(finder.getMethodSignature().indexOf("findByPrimaryKey(") == -1)
					{
						finderNode = new XMLNode(beanNode, "finder");
						String methodName = finder.getMethodSignature();
						String whereClause = finder.getWhereClause();
						if(methodName == null)
						{
							new XMLNode(finderNode, "name", "");
							new XMLNode(finderNode, "query", "");
							new XMLNode(finderNode, "order", "");
						}
						else
						{
							ArrayList arraylist = new ArrayList();
							int bracketPos = methodName.indexOf('(');
							String newMethodName = bracketPos <= -1 ? methodName : methodName.substring(0, bracketPos);
							new XMLNode(finderNode, "name", newMethodName);
							new XMLNode(finderNode, "query", whereClause);
							new XMLNode(finderNode, "order", "");
						}
					}
				}
			}

			if (props.containsKey("read-only"))
				new XMLNode(beanNode, "read-only", (String)props.get("read-only"));

			//if (props.containsKey("tuned-updates"))
			//	new XMLNode(beanNode, "tuned-updates", (String)props.get("tuned-updates"));

			//if (props.containsKey("select-for-update"))
			//	new XMLNode(beanNode, "select-for-update", (String)props.get("select-for-update"));

			if (props.containsKey("time-out"))
				new XMLNode(beanNode, "time-out", (String)props.get("time-out"));

			if (props.containsKey("list-cache-max"))
				new XMLNode(beanNode, "list-cache-max", (String)props.get("list-cache-max"));
		}

		//relationships
		try {
			XMLNode relationshipsNode = new XMLNode(rootNode, "relationships");
			Collection relationships = super.iEjbJar.getRelationshipList();
			if (relationships != null) {
				for (Iterator i = relationships.iterator(); i.hasNext(); ) {
					EjbRelation relation = (EjbRelation) i.next();
					generateRelation(cmpEntityBeans, relationshipsNode, relation);
				}
			}
		} catch(Exception ex) {
			/** @todo Remove try/catch when relationship code is proven to be stable */
			StringWriter wr = new StringWriter();
			ex.printStackTrace(new PrintWriter(wr));
			StringTokenizer st = new StringTokenizer(wr.toString(), "\n", false);
			while (st.hasMoreElements()) {
				Message msg = new Message(st.nextElement().toString().replace('\t', ' '));
				msg.setForeground(Color.red);
				getMsgView().addMessage(deploymentDescriptorCategory, msg);
			}
		}

		String docType = getCMPXMLDoctype();
		DeploymentDescriptor dd = toDescriptor(rootNode, docType, "jbosscmp-jdbc.xml");
		ddList.add(dd);
	}

	private void generateRelation(ArrayList cmpEntityBeans, XMLNode relationshipsNode, EjbRelation relation)
  {
		EjbRelationshipRole role0 = relation.getEjbRelationshipRole();
		EjbRelationshipRole role1 = relation.getEjbRelationshipRole1();

		XMLNode ejbRelationNode = new XMLNode(relationshipsNode, "ejb-relation");
		new XMLNode(ejbRelationNode, "ejb-relation-name", relation.getName());

		Iterator crossTableIterator = role0.getCrossTableList().iterator();

		if (role0.getCrossTableList().iterator().hasNext())
    {
			generateRelationTableMapping(cmpEntityBeans, ejbRelationNode, role0, role1);
		}
    else
    {
			if (role0.getMultiplicityEnum() == EnumMultiplicity.MANY && role1.getMultiplicityEnum() == EnumMultiplicity.MANY)
      {
				// no cross table defined; there's not much more we can do
				return;
			}
			generateForeignKeyMapping(cmpEntityBeans, ejbRelationNode, role0, role1);
		}
	}

	private void generateRelationTableMapping(ArrayList cmpEntityBeans, XMLNode ejbRelationNode, EjbRelationshipRole role0, EjbRelationshipRole role1)
  {
		CrossTable crossTable = (CrossTable) role0.getCrossTableList().iterator().next();

		XMLNode relationTableMappingNode = new XMLNode(ejbRelationNode, "relation-table-mapping");
		new XMLNode(relationTableMappingNode, "table-name", crossTable.getTableName());

		XMLNode ejbRelationshipRole0Node = new XMLNode(ejbRelationNode, "ejb-relationship-role");
		new XMLNode(ejbRelationshipRole0Node, "ejb-relationship-role-name", role0.getEjbRelationshipRoleName());
		XMLNode keyFields0Node = new XMLNode(ejbRelationshipRole0Node, "key-fields");

		XMLNode ejbRelationshipRole1Node = new XMLNode(ejbRelationNode, "ejb-relationship-role");
		new XMLNode(ejbRelationshipRole1Node, "ejb-relationship-role-name", role1.getEjbRelationshipRoleName());
		XMLNode keyFields1Node = new XMLNode(ejbRelationshipRole1Node, "key-fields");

		role0.getLeftTableName(); //seems to sometimes help trigger role.isValid() to be calculated
		role0.getRightTableName(); //seems to sometimes help trigger role.isValid() to be calculated

		if (role0.isValid())
    {
			String leftTableName = role0.getLeftTableName();
			String rightTableName = role0.getRightTableName();
			IEntityBean leftEntityBean = findEntityBeanByTableName(cmpEntityBeans, leftTableName);
			IEntityBean rightEntityBean = findEntityBeanByTableName(cmpEntityBeans, rightTableName);
			if (leftEntityBean == null || rightEntityBean == null) return; //give up
			Collection lcmpFieldList = leftEntityBean.getCmpFieldList();
			Collection rcmpFieldList = rightEntityBean.getCmpFieldList();
			Iterator leftColumnIterator = role0.getLeftTableColumnList().iterator();
			Iterator rightColumnIterator = role0.getRightTableColumnList().iterator();
			ColumnList crossTableColumnList0 = crossTable.getColumnList();
			ColumnList crossTableColumnList1 = crossTable.getColumnList1();

			int col = 0;
			while (leftColumnIterator.hasNext())
      {
				String leftColumnName = leftColumnIterator.hasNext() ? (String) leftColumnIterator.next() : "none";
				ICmpField cmpField = findCmpFieldByColumnName(lcmpFieldList, leftColumnName);
				if (cmpField == null) return; //give up
				XMLNode keyFieldNode = new XMLNode(keyFields0Node, "key-field");
				new XMLNode(keyFieldNode, "field-name", cmpField.getFieldName());
				new XMLNode(keyFieldNode, "column-name", crossTableColumnList0.getColumnNameAt(col).getPCDATA());
				col++;
			}

			col = 0;
			while (rightColumnIterator.hasNext())
      {
				String rightColumnName = rightColumnIterator.hasNext() ? (String) rightColumnIterator.next() : "none";
				ICmpField cmpField = findCmpFieldByColumnName(rcmpFieldList, rightColumnName);
				if (cmpField == null) return; //give up
				XMLNode keyFieldNode = new XMLNode(keyFields1Node, "key-field");
				new XMLNode(keyFieldNode, "field-name", cmpField.getFieldName());
				new XMLNode(keyFieldNode, "column-name", crossTableColumnList1.getColumnNameAt(col).getPCDATA());
				col++;
			}
		}
	}

	private void generateForeignKeyMapping(ArrayList cmpEntityBeans, XMLNode ejbRelationNode, EjbRelationshipRole role0, EjbRelationshipRole role1)
  {
		new XMLNode(ejbRelationNode, "foreign-key-mapping", "");

		XMLNode ejbRelationshipRole0Node = new XMLNode(ejbRelationNode, "ejb-relationship-role");
		new XMLNode(ejbRelationshipRole0Node, "ejb-relationship-role-name", role0.getEjbRelationshipRoleName());
		XMLNode keyFields0Node = new XMLNode(ejbRelationshipRole0Node, "key-fields");

		XMLNode ejbRelationshipRole1Node = new XMLNode(ejbRelationNode, "ejb-relationship-role");
		new XMLNode(ejbRelationshipRole1Node, "ejb-relationship-role-name", role1.getEjbRelationshipRoleName());
		XMLNode keyFields1Node = new XMLNode(ejbRelationshipRole1Node, "key-fields");

		generateForeignKeyMappingRole(cmpEntityBeans, keyFields0Node, keyFields1Node, role0);
	}

	private void generateForeignKeyMappingRole(ArrayList cmpEntityBeans, XMLNode keyFields0Node, XMLNode keyFields1Node, EjbRelationshipRole role)
  {
		role.getLeftTableName(); //seems to sometimes help trigger role.isValid() to be calculated
		role.getRightTableName(); //seems to sometimes help trigger role.isValid() to be calculated

		if (!role.isValid()) return;
		String leftTableName = role.getLeftTableName();
		String rightTableName = role.getRightTableName();
		IEntityBean leftEntityBean = findEntityBeanByTableName(cmpEntityBeans, leftTableName);
		IEntityBean rightEntityBean = findEntityBeanByTableName(cmpEntityBeans, rightTableName);
		if (leftEntityBean == null || rightEntityBean == null) return; //give up
		Collection lcmpFieldList = leftEntityBean.getCmpFieldList();
		Collection rcmpFieldList = rightEntityBean.getCmpFieldList();
		Iterator leftColumnIterator = role.getLeftTableColumnList().iterator();
		Iterator rightColumnIterator = role.getRightTableColumnList().iterator();

		while (rightColumnIterator.hasNext())
    {
			String leftColumnName = (String) leftColumnIterator.next();
			String rightColumnName = (String) rightColumnIterator.next();
			ICmpField lcmpField = findCmpFieldByColumnName(lcmpFieldList, leftColumnName);
			ICmpField rcmpField = findCmpFieldByColumnName(rcmpFieldList, rightColumnName);

			if (lcmpField != null)
      {
				XMLNode keyFieldNode = new XMLNode(keyFields0Node, "key-field");
				new XMLNode(keyFieldNode, "field-name", lcmpField.getFieldName());
				new XMLNode(keyFieldNode, "column-name", rightColumnName);
			}
      else if (rcmpField != null)
      {
				XMLNode keyFieldNode = new XMLNode(keyFields1Node, "key-field");
				new XMLNode(keyFieldNode, "field-name", rcmpField.getFieldName());
				new XMLNode(keyFieldNode, "column-name", leftColumnName);
			}
		}
	}


  private IEntityBean findEntityBeanByTableName(ArrayList cmpEntityBeans, String tableName)
  {
    for (Iterator i = cmpEntityBeans.iterator(); i.hasNext(); )
    {
      IEntityBean entityBean = (IEntityBean)i.next();
      if (entityBean.getTableName().equals(tableName)) return entityBean;
    }
    return null;
  }

  private ICmpField findCmpFieldByColumnName(Collection cmpFieldList, String columnName)
  {
    for (Iterator j = cmpFieldList.iterator(); j.hasNext(); )
    {
      ICmpField cmpField = (ICmpField)j.next();
      String colname = cmpField.getColumnName();
      if (colname != null && colname.equals(columnName)) return cmpField;
    }
    return null;
  }


  protected String getCMPXMLDoctype()
  {
    String docType = "<!DOCTYPE jbosscmp-jdbc PUBLIC '-//JBoss//DTD JBOSSCMP-JDBC 3.0//EN' 'http://www.jboss.org/j2ee/dtd/jbosscmp-jdbc_3_0.dtd'>";
    return docType;
  }

  protected String getJBossXMLDoctype()
  {
    String docType = "<!DOCTYPE jboss PUBLIC '-//JBoss//DTD JBOSS 3.0//EN' 'http://www.jboss.org/j2ee/dtd/jboss_3_0.dtd'>";
    return docType;
  }


  public static EjbPropertyElement[] getPropertyNamesToSurface(EjbReference ejbReference)
  {
    if (ejbReference == null)
    {
      return new EjbPropertyElement[0];
    }

    IEnterpriseBean bean = ejbReference.getBean();
    ArrayList arraylist = new ArrayList();

    //general properties
    for (int i = 0; i < generalProperties.length; i++)
    {
      arraylist.add(new EjbPropertyElement(generalProperties[i]));
    }

    if ((bean instanceof IMessageDrivenBean) && (((IMessageDrivenBean)bean).getSubscriptionDurabilityEnum() == EnumSubscriptionDurability.DURABLE) )
    {
      // mdb properties
      for (int i = 0; i < mdbProperties.length; i++)
      {
        arraylist.add(new EjbPropertyElement(mdbProperties[i]));
      }
    }

    if ((bean instanceof IEntityBean) && (((IEntityBean)bean).getPersistenceTypeEnum() == EnumPersistenceType.CONTAINER) )
    {
      // cmp properties
      for (int i = 0; i < cmpProperties30.length; i++)
      {
        arraylist.add(new EjbPropertyElement(cmpProperties30[i]));
      }
    }

    return (EjbPropertyElement[])arraylist.toArray(new EjbPropertyElement[arraylist.size()]);
  }
}