/*
 * Voyager JBoss OpenTool for JBuilder
 *
 * Copyright (c) 2002 Marcus Redeker, Gedoplan GmbH - Bielefeld, Germany
 *    marcus.redeker@gedoplan.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Cyrille Morvan's excellent 'Kelly JOnAS OpenTool' sources provided
 * much of the inspiration and some of the code for this OpenTool.
 *
*/
package de.gedoplan.opentools.jboss;

import com.borland.jbuilder.info.JBuilderInfo;
import com.borland.primetime.ide.Browser;
import javax.swing.JOptionPane;
import com.borland.jbuilder.node.JBProject;
import java.util.ArrayList;
import com.borland.jbuilder.enterprise.ejb.*;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Project;
import com.borland.primetime.properties.MultipleNodeProperty;
import com.borland.primetime.properties.GlobalProperty;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.ide.MessageCategory;
import com.borland.primetime.ide.MessageView;
import com.borland.primetime.node.Node;
import com.borland.jbuilder.node.JarFileNode;
import com.borland.primetime.ide.Message;
import com.borland.primetime.ide.MessageViewTree;
import javax.swing.ImageIcon;
import javax.swing.Action;
import javax.swing.AbstractAction;
import java.awt.event.ActionEvent;
import java.io.File;
import com.borland.primetime.vfs.VFS;
import java.util.Iterator;
import com.borland.primetime.ide.*;
import java.awt.*;

/**
 * This class holds the code to deploy the different application types to JBoss.
 * Right it supports ejb.jar files, enterprise.ear files and webapp.war files which
 * are copied into the JBoss deploy folder for deployment. Undeployment deletes
 * the selected files from JBoss deploy folder. The different actions are triggered
 * by the context menue 'Deploy Options' on the file node of the supported files.
 *
 * @author <a href="mailto:marcus.redeker@gedoplan.de">Marcus Redeker (Gedoplan GmbH, Germany)</a>
 * @version 1.2
 */
public class JBossEJBDeployer24 implements EjbDeployer
{
  protected MessageCategory deployCategory;
  protected MessageCategory redeployCategory;
  protected MessageCategory undeployCategory;
  protected MessageCategory listCategory;

  ImageIcon ejb_icon;
  ImageIcon war_icon;
  ImageIcon ear_icon;

  public JBossEJBDeployer24()
  {
    deployCategory         = new MessageCategory(JBossResource.get("DEPLOYMENT"));
    deployCategory.setIcon(new ImageIcon(getClass().getResource("/de/gedoplan/opentools/jboss/images/jboss_logo.gif")));

    redeployCategory       = new MessageCategory(JBossResource.get("REDEPLOYMENT"));
    redeployCategory.setIcon(new ImageIcon(getClass().getResource("/de/gedoplan/opentools/jboss/images/jboss_logo.gif")));

    undeployCategory       = new MessageCategory(JBossResource.get("UNDEPLOYMENT"));
    undeployCategory.setIcon(new ImageIcon(getClass().getResource("/de/gedoplan/opentools/jboss/images/jboss_logo.gif")));

    listCategory = new MessageCategory(JBossResource.get("LIST_DEPLOYMENT"));
    listCategory.setIcon(new ImageIcon(getClass().getResource("/de/gedoplan/opentools/jboss/images/jboss_logo.gif")));

    ejb_icon = new ImageIcon(getClass().getResource("/de/gedoplan/opentools/jboss/images/ejb_jar.gif"));
    war_icon = new ImageIcon(getClass().getResource("/de/gedoplan/opentools/jboss/images/webapp_war.gif"));
    ear_icon = new ImageIcon(getClass().getResource("/de/gedoplan/opentools/jboss/images/enterprise_ear.gif"));
  }

  public static void initOpenTool(byte byte0, byte byte1)
  {
    if(JBuilderInfo.isEnterpriseEnabled())
    {
      AppServerManager.registerEjbDeployer(new JBossEJBDeployer24(), JBossResource.get("SERVER_NAME"), JBossResource.get("SERVER_VERSION24"));
    }
  }

  public void deploy(Browser parm1, String[] parm2)
  {
    String msg = JBossResource.get("DEPLOYER_MESSAGE");
    JOptionPane.showMessageDialog(parm1, msg);
    /**@todo: Implement this com.borland.jbuilder.enterprise.ejb.EjbDeployer method*/
  }

  public void deploy(ArrayList nodesToDeploy, JBProject jbproject)
  {
    File deployDirectory = getDeployDir(jbproject);
    if (deployDirectory == null)
    {
      return;
    }

    MessageView msgView = getMsgView();
    msgView.clearMessages(deployCategory);

    String shortName = null;
    String longName = null;
    Url from = null;
    Url to = null;
    Message msg = null;
    for (Iterator i = nodesToDeploy.iterator(); i.hasNext(); )
    {
      JarFileNode aNode = (JarFileNode)i.next();
      shortName = aNode.getDisplayName();
      longName = aNode.getLongDisplayName();
      from = new Url("file", longName);
      to = new Url("file", deployDirectory.getAbsolutePath() + "/" + shortName);
      try
      {
        VFS.copy(from, to);
//        msg = new Message("Deploying " + shortName + "... Done!!");
//        msgView.addMessage(deployCategory, msg);
        getStatusView().setText(shortName + " deployed; " + JBossResource.get("DEPLOY_CHECK_MSG"), Color.blue, true);
      }
      catch(Exception exception)
      {
        exception.printStackTrace();
        msg = new Message("Deploying " + shortName + "... Error copying the file!!");
        msgView.addMessage(deployCategory, msg);
      }
    }
//    msgView.addMessage(deployCategory, "");
//    msgView.addMessage(deployCategory, JBossResource.get("DEPLOY_CHECK_MSG"));
  }

  public void redeploy(ArrayList nodesToDeploy, JBProject jbproject)
  {
    deploy(nodesToDeploy, jbproject);
  }

  public void undeploy(ArrayList nodesToDeploy, JBProject jbproject)
  {
    File deployDirectory = getDeployDir(jbproject);
    if (deployDirectory == null)
    {
      return;
    }

    MessageView msgView = getMsgView();
    msgView.clearMessages(undeployCategory);

    String shortName = null;
    String longName = null;
    Url del = null;
    Message msg = null;
    for (Iterator i = nodesToDeploy.iterator(); i.hasNext(); )
    {
      JarFileNode aNode = (JarFileNode)i.next();
      shortName = aNode.getDisplayName();
      longName = aNode.getLongDisplayName();
      del = new Url("file", deployDirectory.getAbsolutePath() + "/" + shortName);
      try
      {
        VFS.delete(del);
//        msg = new Message("Undeploying " + shortName + "... Done!!");
//        msgView.addMessage(undeployCategory, msg);
        getStatusView().setText(shortName + " undeployed; " + JBossResource.get("DEPLOY_CHECK_MSG"), Color.blue, true);
      }
      catch(Exception exception)
      {
        exception.printStackTrace();
        msg = new Message("Undeploying " + shortName + "... Error deleting the file!!");
        msgView.addMessage(undeployCategory, msg);
      }
    }
//    msgView.addMessage(undeployCategory, "");
//    msgView.addMessage(undeployCategory, JBossResource.get("DEPLOY_CHECK_MSG"));
  }

  public void listDeployments(ArrayList nodesToDeploy, JBProject jbproject)
  {
    File deployDirectory = getDeployDir(jbproject);
    if (deployDirectory == null)
    {
      return;
    }

    int earCount = 0;
    int jarCount = 0;
    int warCount = 0;

    String[] files = deployDirectory.list();
    String aFile = "";
    for (int i = 0; i < files.length; i++)
    {
      aFile = files[i];
      if (aFile.endsWith("ear") || aFile.endsWith("EAR"))
      {
        earCount++;
      }
      else if (aFile.endsWith("jar") || aFile.endsWith("JAR"))
      {
        jarCount++;
      }
      else if (aFile.endsWith("war") || aFile.endsWith("WAR"))
      {
        warCount++;
      }
    }

    MessageView msgView = getMsgView();
    msgView.clearMessages(listCategory);

    Message header = new Message(JBossResource.get("LIST_DEPLOYMENT_HEADER") + deployDirectory);
    Message earFiles = new Message("Enterprise Applications (" + earCount + ")");
    earFiles.setIcon(ear_icon);
    Message ejbFiles = new Message("EJB Applications (" + jarCount + ")");
    ejbFiles.setIcon(ejb_icon);
    Message warFiles = new Message("Web Applications (" + warCount + ")");
    warFiles.setIcon(war_icon);

    msgView.addMessage(listCategory, header);
    msgView.addMessage(listCategory, header, earFiles);
    msgView.addMessage(listCategory, header, ejbFiles);
    msgView.addMessage(listCategory, header, warFiles);

    for (int i = 0; i < files.length; i++)
    {
      aFile = files[i];
      if (aFile.endsWith("ear") || aFile.endsWith("EAR"))
      {
        msgView.addMessage(listCategory, earFiles, new Message(aFile));
      }
      else if (aFile.endsWith("jar") || aFile.endsWith("JAR"))
      {
        msgView.addMessage(listCategory, ejbFiles, new Message(aFile));
      }
      else if (aFile.endsWith("war") || aFile.endsWith("WAR"))
      {
        msgView.addMessage(listCategory, warFiles, new Message(aFile));
      }
    }
  }

  protected File getDeployDir(JBProject jbproject)
  {
    AppServer appServer = AppServerManager.getAppServer(jbproject);
    if (appServer == null || !(appServer instanceof JBossAppServer24))
    {
      return null;
    }

    String homeDir = appServer.getHomeDirectory().getFile();
    if(!homeDir.endsWith("/"))
    {
      homeDir = homeDir + "/";
    }
    File deployDirectory = new File(homeDir + JBossPropertyGroup.DEPLOY_DIRECTORY_NAME_24.getValue() + "/");
    return deployDirectory;
  }

  protected MessageView getMsgView()
  {
    return Browser.getActiveBrowser().getMessageView();
  }

  private StatusView getStatusView()
  {
    return Browser.getActiveBrowser().getStatusView();
  }

}