/*
 * Voyager JBoss OpenTool for JBuilder
 *
 * Copyright (c) 2002 Marcus Redeker, Gedoplan GmbH - Bielefeld, Germany
 *    marcus.redeker@gedoplan.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Cyrille Morvan's excellent 'Kelly JOnAS OpenTool' sources provided
 * much of the inspiration and some of the code for this OpenTool.
 *
*/
package de.gedoplan.opentools.jboss;

import com.borland.jbuilder.info.JBuilderInfo;
import com.borland.primetime.ide.Browser;
import javax.swing.JOptionPane;
import com.borland.jbuilder.node.JBProject;
import java.util.ArrayList;
import com.borland.jbuilder.enterprise.ejb.*;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Project;
import com.borland.primetime.properties.MultipleNodeProperty;
import com.borland.primetime.properties.GlobalProperty;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.ide.MessageCategory;
import com.borland.primetime.ide.MessageView;
import com.borland.primetime.node.Node;
import com.borland.jbuilder.node.JarFileNode;
import com.borland.primetime.ide.Message;
import com.borland.primetime.ide.MessageViewTree;
import javax.swing.ImageIcon;
import javax.swing.Action;
import javax.swing.AbstractAction;
import java.awt.event.ActionEvent;
import java.io.File;
import com.borland.primetime.vfs.VFS;
import java.util.Iterator;

/**
 * This class holds the code to deploy the different application types to JBoss.
 * Right it supports ejb.jar files, enterprise.ear files and webapp.war files which
 * are copied into the JBoss deploy folder for deployment. Undeployment deletes
 * the selected files from JBoss deploy folder. The different actions are triggered
 * by the context menue 'Deploy Options' on the file node of the supported files.
 *
 * @author <a href="mailto:marcus.redeker@gedoplan.de">Marcus Redeker (Gedoplan GmbH, Germany)</a>
 * @version 1.2
 */
public class JBossEJBDeployer30 extends JBossEJBDeployer24
{

  public JBossEJBDeployer30()
  {
    super();
  }

  public static void initOpenTool(byte byte0, byte byte1)
  {
    if(JBuilderInfo.isEnterpriseEnabled())
    {
      AppServerManager.registerEjbDeployer(new JBossEJBDeployer30(), JBossResource.get("SERVER_NAME"), JBossResource.get("SERVER_VERSION30"));
    }
  }


  protected File getDeployDir(JBProject jbproject)
  {
    AppServer appServer = AppServerManager.getAppServer(jbproject);
    if (appServer == null || !(appServer instanceof JBossAppServer30))
    {
      return null;
    }

    String homeDir = appServer.getHomeDirectory().getFile();
    if(!homeDir.endsWith("/"))
    {
      homeDir = homeDir + "/";
    }

    String conf = JBossPropertyGroup.CONFIGURATION_NAME_30.getValue();
    if(!conf.endsWith("/"))
    {
      conf = conf + "/";
    }

    File deployDirectory = new File(homeDir + "server/" + conf + JBossPropertyGroup.DEPLOY_DIRECTORY_NAME_30.getValue() + "/");
    return deployDirectory;
  }


}